<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/rethinkdbs/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/rethinkdbs/metadata.yaml"
sidebar_label: "RethinkDB"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# RethinkDB


<img src="https://netdata.cloud/img/rethinkdb.png" width="150"/>


Plugin: python.d.plugin
Module: rethinkdbs

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors metrics about RethinkDB clusters and database servers.

It uses the `rethinkdb` python module to connect to a RethinkDB server instance and gather statistics.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

When no configuration file is found, the collector tries to connect to 127.0.0.1:28015.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per RethinkDB instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rethinkdb.cluster_connected_servers | connected, missing | servers |
| rethinkdb.cluster_clients_active | active | clients |
| rethinkdb.cluster_queries | queries | queries/s |
| rethinkdb.cluster_documents | reads, writes | documents/s |

### Per database server



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rethinkdb.client_connections | connections | connections |
| rethinkdb.clients_active | active | clients |
| rethinkdb.queries | queries | queries/s |
| rethinkdb.documents | reads, writes | documents/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Required python module

The collector requires the `rethinkdb` python module to be installed.


### Configuration

#### File

The configuration file name for this integration is `python.d/rethinkdbs.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/rethinkdbs.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| host | Hostname or ip of the RethinkDB server. | localhost | no |
| port | Port to connect to the RethinkDB server. | 28015 | no |
| user | The username to use to connect to the RethinkDB server. | admin | no |
| password | The password to use to connect to the RethinkDB server. |  | no |
| timeout | Set a connect timeout to the RethinkDB server. | 2 | no |

</details>

#### Examples

##### Local RethinkDB server

An example of a configuration for a local RethinkDB server

```yaml
localhost:
 name: 'local'
 host: '127.0.0.1'
 port: 28015
 user: "user"
 password: "pass"

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `rethinkdbs` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin rethinkdbs debug trace
  ```


