[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

The Kissat SAT Solver
=====================

Kissat is a "keep it simple and clean bare metal SAT solver" written in C.
It is a port of CaDiCaL back to C with improved data structures, better
scheduling of inprocessing and optimized algorithms and implementation.

Coincidentally "kissat" also means "cats" in Finnish.

Run `./configure && make test` to configure, build and test in `build`.

Binaries are provided with each major [release](https://github.com/arminbiere/kissat/releases/).

You can get more information about Kissat in the last solver description for the SAT Competition 2022:

<a href="https://cca.informatik.uni-freiburg.de/biere/index.html#publications">Armin Biere</a> and <a
href="https://cca.informatik.uni-freiburg.de/fleury/index.html#publications">Mathias Fleury</a>.
<a href="https://cca.informatik.uni-freiburg.de/papers/BiereFleury-SAT-Competition-2022-solvers.pdf">Gimsatul, IsaSAT and Kissat entering the SAT Competition 2022</a>.
In <i>Proc.&nbsp;of SAT Competition 2022 - Solver and Benchmark Descriptions</i>,
Tomas Balyo, Marijn Heule, Markus Iser, Matti J&auml;rvisalo, Martin Suda (editors),
vol.&nbsp;B-2022-1 of Department of Computer Science Report Series B,
pages 10-11,
University of Helsinki, 2022.
<br>
[ <a href="https://cca.informatik.uni-freiburg.de/papers/BiereFleury-SAT-Competition-2022-solvers.pdf">paper</a>
| <a href="https://cca.informatik.uni-freiburg.de/papers/BiereFleury-SAT-Competition-2022-solvers.bib">bibtex</a>
]

See [NEWS.md](NEWS.md) for feature updates.
