#!/bin/bash

# This example requires bash.

[ -z $GTKDIALOG ] && GTKDIALOG=gtkdialog

# Gtkdialog is a C program and the C library will execute a system command
# using /bin/sh so we need to make sure that bash executes any commands.
# Ubuntu users whose /bin/sh links to dash should take note of this fact.
USE_BASH=; [ "`readlink /bin/sh`" != bash ] && USE_BASH="bash -c "

# Tech-Tech by SFR'2013
# GPLv2 applies
# Req: Gtkdialog >=0.8.0, Bash

TEMPDIR=/dev/shm/tech-tech_$$
mkdir $TEMPDIR
trap 'rm -rf $TEMPDIR' EXIT

export PIC=$TEMPDIR/pic.svg
export SINUS=$TEMPDIR/sinus_table
export LINES=$TEMPDIR/lines

: > $SINUS
# Create sinus table
for i in {0..63}; do
  RAD=$(echo "$i*(3.14/32)" | bc -l)
  VAL=$(printf "%.0f" $(echo "s($RAD) * 12" | bc -l))
  echo $VAL >> $SINUS
done

# Convert bitmap (stripped xpm) to SVG's "stroke-dasharray" attributes
cnt=1;curline=0
while read LINE; do
  L[$curline]="0"
  for a in `seq 0 $((${#LINE}))`; do
    [[ "${LINE:$a:1}" != "${LINE:$(($a+1)):1}" ]] && L[$curline]=${L[$curline]}",$cnt" && cnt=1 || ((cnt++))
  done
  ((curline++))
done << EOF
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000001111100000100001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100000000001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000111111111000100011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000001111111111100101111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111110011101111111100001100000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000001100011111100110111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111101111000011111000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000001000001111111100001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110001111000001110000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111100100000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000100001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111100100000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110111111000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111100100000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111100100000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111100111111111110000000100000000001100000000001110000000110000000000111000000011000000000011000000000110000000000000000000000111100111111000000000000001100000000001100000000010000000000001000000000011000000000111000001100010000000000000
0000000000000001111111100100000111110000011110000000111110000000011110000001111110100001111000000111111010000111100000001111100000000000000000001111100111111000001000000011111110000111110000001111111000000111100000001111100000001111100001111110000000000000
0000000000000011111111100100000111110001111111000011111111110001111111000111111111100111111100011111111110011111110000111111111100000000000000001111100111111000011000001111111110001111111000111111111000011111110000111111111100111111110011111110000000000000
0000000000000111111111100100000111110001111111000111111111100001111111011111111111000111111101111111111100111111110000011111111000000000000001111111100111111000001000001111111100001111111001111111110000011111110001111111111001111111111011111100000000000000
0000000000000111111111100100000111110000011111000000111111000000011111100001111110000001111110000111111000000111110000001111110000000000000011111111100111111000001000000111111000000011111100001111100000000111110000001111110000000111111111111000000000000000
0000000000000111001111100111111111110000011111000000111110000000011111000000111110000001111100000011111000000111110000001111100000000000000011111111100111111000001000000011111000000011111000001111100000000111110000001111100000000011111100000000000000000000
0000000000000010001111100100001111110000011111000000111110000000011111000000111110000001111100000011111000000111110000001111100000000000000011111111100111111000001000000011111000000011111000001111100000000111110000001111100000000011111100000000000000000000
0000000000000000001111100100000111110000011111000000111110000000011111000000111110000001111100000011111000000111110000001111100000000000000010001111100111111000001000000011111000000011111000001111100000000111110000001111100000000001111110000000000000000000
0000000000000000001111100100000111110000011111000000111110000000011111000000111110000001111100000011111000000111110000001111100000000000000000001111100111110000001000000011111000000011111000001111100000000111110000001111100000000000111110000000000000000000
0000000000000000001111100100000111110000011111000000111110000000011111000000111110000001111100000011111000000111110000001111100000000000000000001111100111100000001000000011111000000011111000001111100000000111110000001111100000000000111111000000000000000000
0000000000000000111111100110000111110000011111000000111110000000011111000000111110000001111100000011111000000111110000001111100000000000000000001111001111000000001000000011111000000011111000001111100000000111110000001111100000000000111111100000000000000000
0000000000000011111111100111100111110000011111000000111110000000011111000000111110000001111100000011111000000111110000001111100000000000000000001111000000111111111000100011111000000011111000001111100000000111110000001111100000000000011111100000000000000000
0000000000000111111111100111110111110000011111000000111111000000011111110000111110000001111111000011111000000111111000001111100000000000000000001110001111111111111111100011111100000011111000001111100000000111110000001111110000000000011111110000000000000000
0000000000001111111111100111111100000000111111110011111111100000111111111100111110000011111111110011111000001111111110111111100000000000000000011001111111111111111111000011111110001111111110001111111100001111111100111111111000011110111111111000000000000000
0000000000001111111111100111111000000001111111111100111111110001111111111110111111000111111111111011111100011111111111001111110000000000000000000111111111111111111110000011111110011111111110000111111000011111111111001111111100111111100111111111000000000000
0000000000001100001111100111110000000011111111110000011111000011111111111111110000001111111111111111000000001111111100001111110000000000000000011111111111111111111100000001111100000011111000000111110000111111111100000111110001111111000111111110000000000000
0000000000001000001111100101100000000000000111000000001110000010011111111100000000001001111111110000000000000000110000000111111000000000000000100000000000000000011100000000011000000000100000000001000000000001110000000011100001111111000011111100000000000000
0000000000000000001111100100000000000000000000000000000000000000011111000000000000000001111100000000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000010000000110000000000000000
0000000000000000001111100100000000000000000000000000000000000000011111000000000000000001111100000000000000000000000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111100100000000000000000000000000000000000000011111000000000000000001111100000000000000000111110000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111100100000000000000000000000000000000000000011111000000000000000001111100000000000000001111111100000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000001111110100000000000000000000000000000000000000011111000000000000000001111100000000000000011111111110000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000011101110100000000000000000000000000000000000000011111100000000000000001111110000000000000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000011000011100000000000000000000000000000000000000110000000000000000000011000000000000000000000000011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
EOF

echo ${L[@]} > $LINES
# -----------------------------------------------------------------------------

techtech () {
L=( $(<$LINES) )
SIN=( $(<$SINUS) )

echo '<svg width="256" height="64">' > $PIC
#for a in `seq 0 $((${#L[@]}-1))`; do
for ((a=0; a<${#L[@]}; a++)); do
  echo '<line x1="'${SIN[$a]}'" y1="'$(($a+16))'" x2="'$((512+${SIN[$a]}))'" y2="'$(($a+16))'" stroke-dasharray="'${L[$a]}'" stroke="black" stroke-width="2" />' >> $PIC
done
echo '</svg>' >> $PIC

echo ${SIN[63]} ${SIN[@]:0:63} > $SINUS

}
export -f techtech

export MAIN='
<window title="Tech-Tech" resizable="false">
  <pixmap>
    <variable>PICTURE</variable>
    <input file>'$PIC'</input>
  </pixmap>
  <timer visible="false" milliseconds="true" interval="50">
    <action>'$USE_BASH'techtech</action>
    <action>refresh:PICTURE</action>
  </timer>
<action signal="hide">exit:abort</action>
</window>
'

case $1 in
	-d | --dump) echo "$MAIN" ;;
	*) $GTKDIALOG -cp MAIN ;;
esac
