// SPDX-License-Identifier: Apache-2.0 OR MIT

// Use architecture-specific bindings for native x86_64 and x86 architectures.
// They contain minimal Landlock-only bindings with layout tests.
#[allow(dead_code)]
#[allow(non_camel_case_types)]
#[allow(non_snake_case)]
#[allow(non_upper_case_globals)]
#[expect(clippy::arithmetic_side_effects)]
#[cfg(target_arch = "x86_64")]
#[path = "landlock_x86_64.rs"]
mod landlock;

#[allow(dead_code)]
#[allow(non_camel_case_types)]
#[allow(non_snake_case)]
#[allow(non_upper_case_globals)]
#[expect(clippy::arithmetic_side_effects)]
#[cfg(target_arch = "x86")]
#[path = "landlock_i686.rs"]
mod landlock;

// For all other architectures, use the architecture-agnostic landlock_all.rs
// bindings without layout tests.
#[allow(dead_code)]
#[allow(non_camel_case_types)]
#[allow(non_snake_case)]
#[allow(non_upper_case_globals)]
#[expect(clippy::arithmetic_side_effects)]
#[cfg(not(any(target_arch = "x86_64", target_arch = "x86")))]
#[path = "landlock_all.rs"]
mod landlock;

#[rustfmt::skip]
pub use self::landlock::{
    landlock_net_port_attr,
    landlock_path_beneath_attr,
    landlock_rule_type,
    landlock_rule_type_LANDLOCK_RULE_NET_PORT,
    landlock_rule_type_LANDLOCK_RULE_PATH_BENEATH,
    landlock_ruleset_attr,
    LANDLOCK_ACCESS_FS_EXECUTE,
    LANDLOCK_ACCESS_FS_WRITE_FILE,
    LANDLOCK_ACCESS_FS_READ_FILE,
    LANDLOCK_ACCESS_FS_READ_DIR,
    LANDLOCK_ACCESS_FS_REMOVE_DIR,
    LANDLOCK_ACCESS_FS_REMOVE_FILE,
    LANDLOCK_ACCESS_FS_MAKE_CHAR,
    LANDLOCK_ACCESS_FS_MAKE_DIR,
    LANDLOCK_ACCESS_FS_MAKE_REG,
    LANDLOCK_ACCESS_FS_MAKE_SOCK,
    LANDLOCK_ACCESS_FS_MAKE_FIFO,
    LANDLOCK_ACCESS_FS_MAKE_BLOCK,
    LANDLOCK_ACCESS_FS_MAKE_SYM,
    LANDLOCK_ACCESS_FS_REFER,
    LANDLOCK_ACCESS_FS_TRUNCATE,
    LANDLOCK_ACCESS_FS_IOCTL_DEV,
    LANDLOCK_ACCESS_NET_BIND_TCP,
    LANDLOCK_ACCESS_NET_CONNECT_TCP,
    LANDLOCK_SCOPE_ABSTRACT_UNIX_SOCKET,
    LANDLOCK_SCOPE_SIGNAL,
    LANDLOCK_CREATE_RULESET_VERSION,
    LANDLOCK_CREATE_RULESET_ERRATA,
    LANDLOCK_RESTRICT_SELF_LOG_SAME_EXEC_OFF,
    LANDLOCK_RESTRICT_SELF_LOG_NEW_EXEC_ON,
    LANDLOCK_RESTRICT_SELF_LOG_SUBDOMAINS_OFF,
};

use libc::{
    __u32, c_int, c_void, size_t, syscall, SYS_landlock_add_rule, SYS_landlock_create_ruleset,
    SYS_landlock_restrict_self,
};

#[rustfmt::skip]
pub unsafe fn landlock_create_ruleset(attr: *const landlock_ruleset_attr, size: size_t,
                                      flags: __u32) -> c_int {
    syscall(SYS_landlock_create_ruleset, attr, size, flags) as c_int
}

#[rustfmt::skip]
pub unsafe fn landlock_add_rule(ruleset_fd: c_int, rule_type: landlock_rule_type,
                                rule_attr: *const c_void, flags: __u32) -> c_int {
    syscall(SYS_landlock_add_rule, ruleset_fd, rule_type, rule_attr, flags) as c_int
}

pub unsafe fn landlock_restrict_self(ruleset_fd: c_int, flags: __u32) -> c_int {
    syscall(SYS_landlock_restrict_self, ruleset_fd, flags) as c_int
}
