//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armresources_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armresources"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentAtScope.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdateAtScope(ctx, "providers/Microsoft.Management/managementGroups/my-management-group-id", "my-deployment", armresources.Deployment{
		Location: to.Ptr("eastus"),
		Properties: &armresources.DeploymentProperties{
			Mode:       to.Ptr(armresources.DeploymentModeIncremental),
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				URI: to.Ptr("https://example.com/exampleTemplate.json"),
			},
		},
		Tags: map[string]*string{
			"tagKey1": to.Ptr("tag-value-1"),
			"tagKey2": to.Ptr("tag-value-2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("my-deployment"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/my-management-group-id/providers/Microsoft.Resources/deployments/my-deployment"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 			{
	// 				DependsOn: []*armresources.BasicDependency{
	// 					{
	// 						ID: to.Ptr("/providers/Microsoft.Management/managementGroups/my-management-group-id/providers/Microsoft.Authorization/policyDefinitions/policy-definition-name"),
	// 						ResourceName: to.Ptr("policy-definition-name"),
	// 						ResourceType: to.Ptr("Microsoft.Authorization/policyDefinitions"),
	// 				}},
	// 				ID: to.Ptr("/providers/Microsoft.Management/managementGroups/my-management-group-id/providers/Microsoft.Authorization/policyAssignments/location-lock"),
	// 				ResourceName: to.Ptr("location-lock"),
	// 				ResourceType: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 		}},
	// 		Duration: to.Ptr("PT1.2970875S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeIncremental),
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 			{
	// 				Namespace: to.Ptr("Microsoft.Authorization"),
	// 				ResourceTypes: []*armresources.ProviderResourceType{
	// 					{
	// 						Locations: []*string{
	// 							nil},
	// 							ResourceType: to.Ptr("policyDefinitions"),
	// 						},
	// 						{
	// 							Locations: []*string{
	// 								nil},
	// 								ResourceType: to.Ptr("policyAssignments"),
	// 						}},
	// 					},
	// 					{
	// 						Namespace: to.Ptr("Microsoft.Resources"),
	// 						ResourceTypes: []*armresources.ProviderResourceType{
	// 							{
	// 								Locations: []*string{
	// 									to.Ptr("eastus")},
	// 									ResourceType: to.Ptr("deployments"),
	// 							}},
	// 					}},
	// 					ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 					Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-24T22:52:38.789Z"); return t}()),
	// 				},
	// 				Tags: map[string]*string{
	// 					"tagKey1": to.Ptr("tag-value-1"),
	// 					"tagKey2": to.Ptr("tag-value-2"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentAtTenant.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtTenantScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdateAtTenantScope(ctx, "tenant-dep01", armresources.ScopedDeployment{
		Location: to.Ptr("eastus"),
		Properties: &armresources.DeploymentProperties{
			Mode:       to.Ptr(armresources.DeploymentModeIncremental),
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				URI: to.Ptr("https://example.com/exampleTemplate.json"),
			},
		},
		Tags: map[string]*string{
			"tagKey1": to.Ptr("tag-value-1"),
			"tagKey2": to.Ptr("tag-value-2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("tenant-dep01"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/providers/Microsoft.Resources/deployments/tenant-dep01"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 			{
	// 				DependsOn: []*armresources.BasicDependency{
	// 					{
	// 						ID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/policy-definition-name"),
	// 						ResourceName: to.Ptr("policy-definition-name"),
	// 						ResourceType: to.Ptr("Microsoft.Authorization/policyDefinitions"),
	// 				}},
	// 				ID: to.Ptr("/providers/Microsoft.Authorization/policyAssignments/location-lock"),
	// 				ResourceName: to.Ptr("location-lock"),
	// 				ResourceType: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 		}},
	// 		Duration: to.Ptr("PT1.2970875S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeIncremental),
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 			{
	// 				Namespace: to.Ptr("Microsoft.Authorization"),
	// 				ResourceTypes: []*armresources.ProviderResourceType{
	// 					{
	// 						Locations: []*string{
	// 							nil},
	// 							ResourceType: to.Ptr("policyDefinitions"),
	// 						},
	// 						{
	// 							Locations: []*string{
	// 								nil},
	// 								ResourceType: to.Ptr("policyAssignments"),
	// 						}},
	// 					},
	// 					{
	// 						Namespace: to.Ptr("Microsoft.Resources"),
	// 						ResourceTypes: []*armresources.ProviderResourceType{
	// 							{
	// 								Locations: []*string{
	// 									to.Ptr("eastus")},
	// 									ResourceType: to.Ptr("deployments"),
	// 							}},
	// 					}},
	// 					ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 					Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-24T22:52:38.789Z"); return t}()),
	// 				},
	// 				Tags: map[string]*string{
	// 					"tagKey1": to.Ptr("tag-value-1"),
	// 					"tagKey2": to.Ptr("tag-value-2"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnTenant.json
func ExampleDeploymentsClient_BeginWhatIfAtTenantScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginWhatIfAtTenantScope(ctx, "exampleDeploymentName", armresources.ScopedDeploymentWhatIf{
		Location: to.Ptr("eastus"),
		Properties: &armresources.DeploymentWhatIfProperties{
			Mode:         to.Ptr(armresources.DeploymentModeIncremental),
			Parameters:   map[string]any{},
			TemplateLink: &armresources.TemplateLink{},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WhatIfOperationResult = armresources.WhatIfOperationResult{
	// 	Properties: &armresources.WhatIfOperationProperties{
	// 		Changes: []*armresources.WhatIfChange{
	// 			{
	// 				After: map[string]any{
	// 					"name": "myManagementGroup",
	// 					"type": "Microsoft.Management/managementGroups",
	// 					"apiVersion": "2019-11-01",
	// 					"id": "/providers/Microsoft.Management/managementGroups/myManagementGroup",
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeCreate),
	// 				ResourceID: to.Ptr("/providers/Microsoft.Management/managementGroups/myManagementGroup"),
	// 		}},
	// 	},
	// 	Status: to.Ptr("Succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentAtManagementGroup.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdateAtManagementGroupScope(ctx, "my-management-group-id", "my-deployment", armresources.ScopedDeployment{
		Location: to.Ptr("eastus"),
		Properties: &armresources.DeploymentProperties{
			Mode:       to.Ptr(armresources.DeploymentModeIncremental),
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				URI: to.Ptr("https://example.com/exampleTemplate.json"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("my-deployment"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/my-management-group-id/providers/Microsoft.Resources/deployments/my-deployment"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 			{
	// 				DependsOn: []*armresources.BasicDependency{
	// 					{
	// 						ID: to.Ptr("/providers/Microsoft.Management/managementGroups/my-management-group-id/providers/Microsoft.Authorization/policyDefinitions/policy-definition-name"),
	// 						ResourceName: to.Ptr("policy-definition-name"),
	// 						ResourceType: to.Ptr("Microsoft.Authorization/policyDefinitions"),
	// 				}},
	// 				ID: to.Ptr("/providers/Microsoft.Management/managementGroups/my-management-group-id/providers/Microsoft.Authorization/policyAssignments/location-lock"),
	// 				ResourceName: to.Ptr("location-lock"),
	// 				ResourceType: to.Ptr("Microsoft.Authorization/policyAssignments"),
	// 		}},
	// 		Duration: to.Ptr("PT1.2970875S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeIncremental),
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 			{
	// 				Namespace: to.Ptr("Microsoft.Authorization"),
	// 				ResourceTypes: []*armresources.ProviderResourceType{
	// 					{
	// 						Locations: []*string{
	// 							nil},
	// 							ResourceType: to.Ptr("policyDefinitions"),
	// 						},
	// 						{
	// 							Locations: []*string{
	// 								nil},
	// 								ResourceType: to.Ptr("policyAssignments"),
	// 						}},
	// 					},
	// 					{
	// 						Namespace: to.Ptr("Microsoft.Resources"),
	// 						ResourceTypes: []*armresources.ProviderResourceType{
	// 							{
	// 								Locations: []*string{
	// 									to.Ptr("eastus")},
	// 									ResourceType: to.Ptr("deployments"),
	// 							}},
	// 					}},
	// 					ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 					Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-24T22:52:38.789Z"); return t}()),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnManagementGroup.json
func ExampleDeploymentsClient_BeginWhatIfAtManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginWhatIfAtManagementGroupScope(ctx, "myManagementGruop", "exampleDeploymentName", armresources.ScopedDeploymentWhatIf{
		Location: to.Ptr("eastus"),
		Properties: &armresources.DeploymentWhatIfProperties{
			Mode:         to.Ptr(armresources.DeploymentModeIncremental),
			Parameters:   map[string]any{},
			TemplateLink: &armresources.TemplateLink{},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WhatIfOperationResult = armresources.WhatIfOperationResult{
	// 	Properties: &armresources.WhatIfOperationProperties{
	// 		Changes: []*armresources.WhatIfChange{
	// 			{
	// 				After: map[string]any{
	// 					"before":map[string]any{
	// 						"name": "myPolicyAssignment",
	// 						"type": "Microsoft.Authorization/policyAssignments",
	// 						"apiVersion": "2019-06-01",
	// 						"id": "/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyAssignment",
	// 						"location": "westus2",
	// 						"properties":map[string]any{
	// 							"enforcementMode": "DoNotEnforce",
	// 							"policyDefinitionId": "/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyDefinition",
	// 							"scope": "/subscriptions/00000000-0000-0000-0000-000000000001",
	// 						},
	// 					},
	// 					"changeType": "Modify",
	// 					"delta":[]any{
	// 						map[string]any{
	// 							"path": "properties.enforcementMode",
	// 							"after": "DoNotEnforce",
	// 							"before": "Default",
	// 							"propertyChangeType": "Modify",
	// 						},
	// 					},
	// 					"resourceId": "/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyAssignment",
	// 				},
	// 				Before: map[string]any{
	// 					"name": "myPolicyAssignment",
	// 					"type": "Microsoft.Authorization/policyAssignments",
	// 					"apiVersion": "2019-06-01",
	// 					"id": "/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyAssignment",
	// 					"location": "westus2",
	// 					"properties":map[string]any{
	// 						"enforcementMode": "Default",
	// 						"policyDefinitionId": "/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyDefinition",
	// 						"scope": "/subscriptions/00000000-0000-0000-0000-000000000001",
	// 					},
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeModify),
	// 				ResourceID: to.Ptr("/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyAssignment"),
	// 			},
	// 			{
	// 				After: map[string]any{
	// 					"name": "myPolicyAssignment2",
	// 					"type": "Microsoft.Authorization/policyAssignments",
	// 					"apiVersion": "2019-06-01",
	// 					"id": "/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyAssignment2",
	// 					"location": "westus2",
	// 					"properties":map[string]any{
	// 						"enforcementMode": "Default",
	// 						"policyDefinitionId": "/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyDefinition",
	// 						"scope": "/subscriptions/00000000-0000-0000-0000-000000000002",
	// 					},
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeCreate),
	// 				ResourceID: to.Ptr("/providers/Microsoft.Management/managementGroups/myManagementGroup/providers/Microsoft.Authorization/policyAssignments/myPolicyAssignment2"),
	// 		}},
	// 	},
	// 	Status: to.Ptr("Succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentSubscriptionTemplateSpecsWithId.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdateAtSubscriptionScope(ctx, "my-deployment", armresources.Deployment{
		Location: to.Ptr("eastus"),
		Properties: &armresources.DeploymentProperties{
			Mode:       to.Ptr(armresources.DeploymentModeIncremental),
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("my-deployment"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/providers/Microsoft.Resources/deployments/my-deployment"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 		},
	// 		Duration: to.Ptr("PT1.2637681S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeIncremental),
	// 		OutputResources: []*armresources.ResourceReference{
	// 		},
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 		},
	// 		ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 		TemplateHash: to.Ptr("0000000000000000000"),
	// 		TemplateLink: &armresources.TemplateLink{
	// 			ContentVersion: to.Ptr("1.0.0.0"),
	// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
	// 		},
	// 		Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-05T01:51:58.628Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnSubscription.json
func ExampleDeploymentsClient_BeginWhatIfAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginWhatIfAtSubscriptionScope(ctx, "my-deployment", armresources.DeploymentWhatIf{
		Location: to.Ptr("westus"),
		Properties: &armresources.DeploymentWhatIfProperties{
			Mode:         to.Ptr(armresources.DeploymentModeIncremental),
			Parameters:   map[string]any{},
			TemplateLink: &armresources.TemplateLink{},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WhatIfOperationResult = armresources.WhatIfOperationResult{
	// 	Properties: &armresources.WhatIfOperationProperties{
	// 		Changes: []*armresources.WhatIfChange{
	// 			{
	// 				After: map[string]any{
	// 					"name": "myExistingIdentity",
	// 					"type": "Microsoft.ManagedIdentity/userAssignedIdentities",
	// 					"apiVersion": "2018-11-30",
	// 					"id": "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myExistingIdentity",
	// 					"location": "westus2",
	// 					"tags":map[string]any{
	// 						"myNewTag": "my tag value",
	// 					},
	// 				},
	// 				Before: map[string]any{
	// 					"name": "myExistingIdentity",
	// 					"type": "Microsoft.ManagedIdentity/userAssignedIdentities",
	// 					"apiVersion": "2018-11-30",
	// 					"id": "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myExistingIdentity",
	// 					"location": "westus2",
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeModify),
	// 				Delta: []*armresources.WhatIfPropertyChange{
	// 					{
	// 						Path: to.Ptr("tags.myNewTag"),
	// 						After: "my tag value",
	// 						PropertyChangeType: to.Ptr(armresources.PropertyChangeTypeCreate),
	// 				}},
	// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myExistingIdentity"),
	// 			},
	// 			{
	// 				After: map[string]any{
	// 					"name": "myNewIdentity",
	// 					"type": "Microsoft.ManagedIdentity/userAssignedIdentities",
	// 					"apiVersion": "2018-11-30",
	// 					"id": "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myNewIdentity",
	// 					"location": "eastus",
	// 					"tags":map[string]any{
	// 						"myOtherNewTag": "another new tag value",
	// 					},
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeCreate),
	// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myNewIdentity"),
	// 			},
	// 			{
	// 				After: map[string]any{
	// 					"name": "my-resource-group2",
	// 					"type": "Microsoft.Resources/resourceGroups",
	// 					"apiVersion": "2019-03-01",
	// 					"id": "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group2",
	// 					"location": "{location3}",
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeCreate),
	// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group2"),
	// 		}},
	// 	},
	// 	Status: to.Ptr("succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentResourceGroup.json
func ExampleDeploymentsClient_BeginCreateOrUpdate_createADeploymentThatWillDeployATemplateWithAUriAndQueryString() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdate(ctx, "my-resource-group", "my-deployment", armresources.Deployment{
		Properties: &armresources.DeploymentProperties{
			Mode:       to.Ptr(armresources.DeploymentModeIncremental),
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				QueryString: to.Ptr("sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=xxxxxxxx0xxxxxxxxxxxxx%2bxxxxxxxxxxxxxxxxxxxx%3d"),
				URI:         to.Ptr("https://example.com/exampleTemplate.json"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("my-deployment"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/deployments/my-deployment"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 		},
	// 		Duration: to.Ptr("PT22.8356799S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeIncremental),
	// 		OutputResources: []*armresources.ResourceReference{
	// 			{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Storage/storageAccounts/my-storage-account"),
	// 		}},
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 			{
	// 				Namespace: to.Ptr("Microsoft.Storage"),
	// 				ResourceTypes: []*armresources.ProviderResourceType{
	// 					{
	// 						Locations: []*string{
	// 							to.Ptr("eastus")},
	// 							ResourceType: to.Ptr("storageAccounts"),
	// 					}},
	// 			}},
	// 			ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 			TemplateHash: to.Ptr("0000000000000000000"),
	// 			TemplateLink: &armresources.TemplateLink{
	// 				ContentVersion: to.Ptr("1.0.0.0"),
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
	// 			},
	// 			Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-05T01:20:01.723Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentResourceGroupTemplateSpecsWithId.json
func ExampleDeploymentsClient_BeginCreateOrUpdate_createADeploymentThatWillDeployATemplateSpecWithTheGivenResourceId() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdate(ctx, "my-resource-group", "my-deployment", armresources.Deployment{
		Properties: &armresources.DeploymentProperties{
			Mode:       to.Ptr(armresources.DeploymentModeIncremental),
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("my-deployment"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/deployments/my-deployment"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 		},
	// 		Duration: to.Ptr("PT22.8356799S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeIncremental),
	// 		OutputResources: []*armresources.ResourceReference{
	// 			{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Storage/storageAccounts/my-storage-account"),
	// 		}},
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 			{
	// 				Namespace: to.Ptr("Microsoft.Storage"),
	// 				ResourceTypes: []*armresources.ProviderResourceType{
	// 					{
	// 						Locations: []*string{
	// 							to.Ptr("eastus")},
	// 							ResourceType: to.Ptr("storageAccounts"),
	// 					}},
	// 			}},
	// 			ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 			TemplateHash: to.Ptr("0000000000000000000"),
	// 			TemplateLink: &armresources.TemplateLink{
	// 				ContentVersion: to.Ptr("1.0.0.0"),
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.Resources/TemplateSpecs/TemplateSpec-Name/versions/v1"),
	// 			},
	// 			Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-05T01:20:01.723Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentWithOnErrorDeploymentSpecificDeployment.json
func ExampleDeploymentsClient_BeginCreateOrUpdate_createADeploymentThatWillRedeployAnotherDeploymentOnFailure() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdate(ctx, "my-resource-group", "my-deployment", armresources.Deployment{
		Properties: &armresources.DeploymentProperties{
			Mode: to.Ptr(armresources.DeploymentModeComplete),
			OnErrorDeployment: &armresources.OnErrorDeployment{
				Type:           to.Ptr(armresources.OnErrorDeploymentTypeSpecificDeployment),
				DeploymentName: to.Ptr("name-of-deployment-to-use"),
			},
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				URI: to.Ptr("https://example.com/exampleTemplate.json"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("my-deployment"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/Microsoft.Resources/deployments/my-deployment"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 			{
	// 				DependsOn: []*armresources.BasicDependency{
	// 					{
	// 						ID: to.Ptr("{resourceid}"),
	// 						ResourceName: to.Ptr("VNet1"),
	// 						ResourceType: to.Ptr("Microsoft.Network/virtualNetworks"),
	// 				}},
	// 				ID: to.Ptr("{resourceid}"),
	// 				ResourceName: to.Ptr("VNet1/Subnet1"),
	// 				ResourceType: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 			},
	// 			{
	// 				DependsOn: []*armresources.BasicDependency{
	// 					{
	// 						ID: to.Ptr("{resourceid}"),
	// 						ResourceName: to.Ptr("VNet1"),
	// 						ResourceType: to.Ptr("Microsoft.Network/virtualNetworks"),
	// 					},
	// 					{
	// 						ID: to.Ptr("{resourceid}"),
	// 						ResourceName: to.Ptr("VNet1/Subnet1"),
	// 						ResourceType: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 				}},
	// 				ID: to.Ptr("{resourceid}"),
	// 				ResourceName: to.Ptr("VNet1/Subnet2"),
	// 				ResourceType: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 		}},
	// 		Duration: to.Ptr("PT0.8204881S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeComplete),
	// 		OnErrorDeployment: &armresources.OnErrorDeploymentExtended{
	// 			Type: to.Ptr(armresources.OnErrorDeploymentTypeSpecificDeployment),
	// 			DeploymentName: to.Ptr("name-of-deployment-to-use"),
	// 		},
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 			{
	// 				Namespace: to.Ptr("Microsoft.Network"),
	// 				ResourceTypes: []*armresources.ProviderResourceType{
	// 					{
	// 						Locations: []*string{
	// 							to.Ptr("centralus")},
	// 							ResourceType: to.Ptr("virtualNetworks"),
	// 						},
	// 						{
	// 							Locations: []*string{
	// 								to.Ptr("centralus")},
	// 								ResourceType: to.Ptr("virtualNetworks/subnets"),
	// 						}},
	// 				}},
	// 				ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 				TemplateLink: &armresources.TemplateLink{
	// 					ContentVersion: to.Ptr("1.0.0.0"),
	// 					URI: to.Ptr("https://example.com/exampleTemplate.json"),
	// 				},
	// 				Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentWithOnErrorDeploymentLastSuccessful.json
func ExampleDeploymentsClient_BeginCreateOrUpdate_createADeploymentThatWillRedeployTheLastSuccessfulDeploymentOnFailure() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdate(ctx, "my-resource-group", "my-deployment", armresources.Deployment{
		Properties: &armresources.DeploymentProperties{
			Mode: to.Ptr(armresources.DeploymentModeComplete),
			OnErrorDeployment: &armresources.OnErrorDeployment{
				Type: to.Ptr(armresources.OnErrorDeploymentTypeLastSuccessful),
			},
			Parameters: map[string]any{},
			TemplateLink: &armresources.TemplateLink{
				URI: to.Ptr("https://example.com/exampleTemplate.json"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentExtended = armresources.DeploymentExtended{
	// 	Name: to.Ptr("my-deployment"),
	// 	Type: to.Ptr("Microsoft.Resources/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/Microsoft.Resources/deployments/my-deployment"),
	// 	Properties: &armresources.DeploymentPropertiesExtended{
	// 		CorrelationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		Dependencies: []*armresources.Dependency{
	// 			{
	// 				DependsOn: []*armresources.BasicDependency{
	// 					{
	// 						ID: to.Ptr("{resourceid}"),
	// 						ResourceName: to.Ptr("VNet1"),
	// 						ResourceType: to.Ptr("Microsoft.Network/virtualNetworks"),
	// 				}},
	// 				ID: to.Ptr("{resourceid}"),
	// 				ResourceName: to.Ptr("VNet1/Subnet1"),
	// 				ResourceType: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 			},
	// 			{
	// 				DependsOn: []*armresources.BasicDependency{
	// 					{
	// 						ID: to.Ptr("{resourceid}"),
	// 						ResourceName: to.Ptr("VNet1"),
	// 						ResourceType: to.Ptr("Microsoft.Network/virtualNetworks"),
	// 					},
	// 					{
	// 						ID: to.Ptr("{resourceid}"),
	// 						ResourceName: to.Ptr("VNet1/Subnet1"),
	// 						ResourceType: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 				}},
	// 				ID: to.Ptr("{resourceid}"),
	// 				ResourceName: to.Ptr("VNet1/Subnet2"),
	// 				ResourceType: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 		}},
	// 		Duration: to.Ptr("PT0.8204881S"),
	// 		Mode: to.Ptr(armresources.DeploymentModeComplete),
	// 		OnErrorDeployment: &armresources.OnErrorDeploymentExtended{
	// 			Type: to.Ptr(armresources.OnErrorDeploymentTypeLastSuccessful),
	// 			DeploymentName: to.Ptr("{nameOfLastSuccesfulDeployment}"),
	// 		},
	// 		Parameters: map[string]any{
	// 		},
	// 		Providers: []*armresources.Provider{
	// 			{
	// 				Namespace: to.Ptr("Microsoft.Network"),
	// 				ResourceTypes: []*armresources.ProviderResourceType{
	// 					{
	// 						Locations: []*string{
	// 							to.Ptr("centralus")},
	// 							ResourceType: to.Ptr("virtualNetworks"),
	// 						},
	// 						{
	// 							Locations: []*string{
	// 								to.Ptr("centralus")},
	// 								ResourceType: to.Ptr("virtualNetworks/subnets"),
	// 						}},
	// 				}},
	// 				ProvisioningState: to.Ptr(armresources.ProvisioningStateSucceeded),
	// 				TemplateLink: &armresources.TemplateLink{
	// 					ContentVersion: to.Ptr("1.0.0.0"),
	// 					URI: to.Ptr("https://example.com/exampleTemplate.json"),
	// 				},
	// 				Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-01T00:00:00.000Z"); return t}()),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnResourceGroup.json
func ExampleDeploymentsClient_BeginWhatIf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginWhatIf(ctx, "my-resource-group", "my-deployment", armresources.DeploymentWhatIf{
		Properties: &armresources.DeploymentWhatIfProperties{
			Mode:         to.Ptr(armresources.DeploymentModeIncremental),
			Parameters:   map[string]any{},
			TemplateLink: &armresources.TemplateLink{},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WhatIfOperationResult = armresources.WhatIfOperationResult{
	// 	Properties: &armresources.WhatIfOperationProperties{
	// 		Changes: []*armresources.WhatIfChange{
	// 			{
	// 				After: map[string]any{
	// 					"name": "myExistingIdentity",
	// 					"type": "Microsoft.ManagedIdentity/userAssignedIdentities",
	// 					"apiVersion": "2018-11-30",
	// 					"id": "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myExistingIdentity",
	// 					"location": "westus2",
	// 					"tags":map[string]any{
	// 						"myNewTag": "my tag value",
	// 					},
	// 				},
	// 				Before: map[string]any{
	// 					"name": "myExistingIdentity",
	// 					"type": "Microsoft.ManagedIdentity/userAssignedIdentities",
	// 					"apiVersion": "2018-11-30",
	// 					"id": "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myExistingIdentity",
	// 					"location": "westus2",
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeModify),
	// 				Delta: []*armresources.WhatIfPropertyChange{
	// 					{
	// 						Path: to.Ptr("tags.myNewTag"),
	// 						After: "my tag value",
	// 						PropertyChangeType: to.Ptr(armresources.PropertyChangeTypeCreate),
	// 				}},
	// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myExistingIdentity"),
	// 			},
	// 			{
	// 				After: map[string]any{
	// 					"name": "myNewIdentity",
	// 					"type": "Microsoft.ManagedIdentity/userAssignedIdentities",
	// 					"apiVersion": "2018-11-30",
	// 					"id": "/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myNewIdentity",
	// 					"location": "eastus",
	// 					"tags":map[string]any{
	// 						"myOtherNewTag": "another new tag value",
	// 					},
	// 				},
	// 				ChangeType: to.Ptr(armresources.ChangeTypeCreate),
	// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000001/resourceGroups/my-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myNewIdentity"),
	// 		}},
	// 	},
	// 	Status: to.Ptr("succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/CalculateTemplateHash.json
func ExampleDeploymentsClient_CalculateTemplateHash() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDeploymentsClient().CalculateTemplateHash(ctx, map[string]any{
		"$schema":        "http://schemas.management.azure.com/deploymentTemplate?api-version=2014-04-01-preview",
		"contentVersion": "1.0.0.0",
		"outputs": map[string]any{
			"string": map[string]any{
				"type":  "string",
				"value": "myvalue",
			},
		},
		"parameters": map[string]any{
			"string": map[string]any{
				"type": "string",
			},
		},
		"resources": []any{},
		"variables": map[string]any{
			"array": []any{
				float64(1),
				float64(2),
				float64(3),
				float64(4),
			},
			"bool": true,
			"int":  float64(42),
			"object": map[string]any{
				"object": map[string]any{
					"location": "West US",
					"vmSize":   "Large",
				},
			},
			"string": "string",
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TemplateHashResult = armresources.TemplateHashResult{
	// 	MinifiedTemplate: to.Ptr("{\"$SCHEMA\":\"HTTP://SCHEMAS.MANAGEMENT.AZURE.COM/DEPLOYMENTTEMPLATE?API-VERSION=2014-04-01-PREVIEW\",\"CONTENTVERSION\":\"1.0.0.0\",\"PARAMETERS\":{\"STRING\":{\"TYPE\":\"STRING\"}},\"VARIABLES\":{\"STRING\":\"STRING\",\"INT\":42,\"BOOL\":TRUE,\"ARRAY\":[1,2,3,4],\"OBJECT\":{\"OBJECT\":{\"VMSIZE\":\"LARGE\",\"LOCATION\":\"WEST US\"}}},\"RESOURCES\":[],\"OUTPUTS\":{\"STRING\":{\"TYPE\":\"STRING\",\"VALUE\":\"MYVALUE\"}}}"),
	// 	TemplateHash: to.Ptr("695440707931307747"),
	// }
}
