﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/EngineVersion.h>
#include <aws/athena/model/SessionStatus.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {

/**
 * <p>Contains summary information about a session.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/SessionSummary">AWS
 * API Reference</a></p>
 */
class SessionSummary {
 public:
  AWS_ATHENA_API SessionSummary() = default;
  AWS_ATHENA_API SessionSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_ATHENA_API SessionSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ATHENA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The session ID.</p>
   */
  inline const Aws::String& GetSessionId() const { return m_sessionId; }
  inline bool SessionIdHasBeenSet() const { return m_sessionIdHasBeenSet; }
  template <typename SessionIdT = Aws::String>
  void SetSessionId(SessionIdT&& value) {
    m_sessionIdHasBeenSet = true;
    m_sessionId = std::forward<SessionIdT>(value);
  }
  template <typename SessionIdT = Aws::String>
  SessionSummary& WithSessionId(SessionIdT&& value) {
    SetSessionId(std::forward<SessionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The session description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  SessionSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The engine version used by the session (for example, <code>PySpark engine
   * version 3</code>).</p>
   */
  inline const EngineVersion& GetEngineVersion() const { return m_engineVersion; }
  inline bool EngineVersionHasBeenSet() const { return m_engineVersionHasBeenSet; }
  template <typename EngineVersionT = EngineVersion>
  void SetEngineVersion(EngineVersionT&& value) {
    m_engineVersionHasBeenSet = true;
    m_engineVersion = std::forward<EngineVersionT>(value);
  }
  template <typename EngineVersionT = EngineVersion>
  SessionSummary& WithEngineVersion(EngineVersionT&& value) {
    SetEngineVersion(std::forward<EngineVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The notebook version.</p>
   */
  inline const Aws::String& GetNotebookVersion() const { return m_notebookVersion; }
  inline bool NotebookVersionHasBeenSet() const { return m_notebookVersionHasBeenSet; }
  template <typename NotebookVersionT = Aws::String>
  void SetNotebookVersion(NotebookVersionT&& value) {
    m_notebookVersionHasBeenSet = true;
    m_notebookVersion = std::forward<NotebookVersionT>(value);
  }
  template <typename NotebookVersionT = Aws::String>
  SessionSummary& WithNotebookVersion(NotebookVersionT&& value) {
    SetNotebookVersion(std::forward<NotebookVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains information about the session status.</p>
   */
  inline const SessionStatus& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = SessionStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = SessionStatus>
  SessionSummary& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sessionId;
  bool m_sessionIdHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  EngineVersion m_engineVersion;
  bool m_engineVersionHasBeenSet = false;

  Aws::String m_notebookVersion;
  bool m_notebookVersionHasBeenSet = false;

  SessionStatus m_status;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
