/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.common.search.aggregations.MissingHelper;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineAggregationBuilder;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoLineMultiValuesSource;

public class GeoLineBucketedSort
extends BucketedSort.ForDoubles {
    private final GeoLineMultiValuesSource valuesSources;

    public GeoLineBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, GeoLineMultiValuesSource valuesSources, Extra extra) {
        super(bigArrays, sortOrder, format, bucketSize, (BucketedSort.ExtraData)extra);
        this.valuesSources = valuesSources;
    }

    public long sizeOf(long bucket) {
        int bucketSize = this.getBucketSize();
        long rootIndex = bucket * (long)bucketSize;
        if (rootIndex >= this.values().size()) {
            return 0L;
        }
        long start = this.inHeapMode(bucket) ? rootIndex : rootIndex + (long)this.getNextGatherOffset(rootIndex) + 1L;
        long end = rootIndex + (long)bucketSize;
        long size = 0L;
        for (long index = start; index < end; ++index) {
            if (((Extra)this.extra).empty.isEmpty(index)) continue;
            ++size;
        }
        return size;
    }

    public double[] getSortValues(long bucket) {
        int bucketSize = this.getBucketSize();
        long rootIndex = bucket * (long)bucketSize;
        if (rootIndex >= this.values().size()) {
            return new double[0];
        }
        long start = this.inHeapMode(bucket) ? rootIndex : rootIndex + (long)this.getNextGatherOffset(rootIndex) + 1L;
        long end = rootIndex + (long)bucketSize;
        double[] result = new double[(int)this.sizeOf(bucket)];
        int i = 0;
        for (long index = start; index < end; ++index) {
            if (((Extra)this.extra).empty.isEmpty(index)) continue;
            double timestampValue = ((DoubleArray)this.values()).get(index);
            result[i++] = timestampValue;
        }
        return result;
    }

    public long[] getPoints(long bucket) {
        int bucketSize = this.getBucketSize();
        long rootIndex = bucket * (long)bucketSize;
        if (rootIndex >= this.values().size()) {
            return new long[0];
        }
        long start = this.inHeapMode(bucket) ? rootIndex : rootIndex + (long)this.getNextGatherOffset(rootIndex) + 1L;
        long end = rootIndex + (long)bucketSize;
        long[] result = new long[(int)this.sizeOf(bucket)];
        int i = 0;
        for (long index = start; index < end; ++index) {
            if (((Extra)this.extra).empty.isEmpty(index)) continue;
            long geoPointValue = ((Extra)this.extra).values.get(index);
            result[i++] = geoPointValue;
        }
        return result;
    }

    public BucketedSort.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
        return new BucketedSort.ForDoubles.Leaf(ctx){
            private final SortedNumericDoubleValues docSortValues;
            private double docValue;
            {
                super((BucketedSort.ForDoubles)GeoLineBucketedSort.this, arg0);
                this.docSortValues = GeoLineBucketedSort.this.valuesSources.getNumericField(GeoLineAggregationBuilder.SORT_FIELD.getPreferredName(), ctx);
            }

            protected boolean advanceExact(int doc) throws IOException {
                if (this.docSortValues.advanceExact(doc)) {
                    if (this.docSortValues.docValueCount() > 1) {
                        throw new AggregationExecutionException("Encountered more than one sort value for a single document. Use a script to combine multiple sort-values-per-doc into a single value.");
                    }
                    assert (this.docSortValues.docValueCount() == 1);
                    this.docValue = this.docSortValues.nextValue();
                    return true;
                }
                this.docValue = -9.223372036854776E18;
                return false;
            }

            protected double docValue() {
                return this.docValue;
            }
        };
    }

    static class Extra
    implements BucketedSort.ExtraData,
    Releasable {
        private final BigArrays bigArrays;
        private final GeoLineMultiValuesSource valuesSources;
        private LongArray values;
        private final MissingHelper empty;

        Extra(BigArrays bigArrays, GeoLineMultiValuesSource valuesSources) {
            this.bigArrays = bigArrays;
            this.valuesSources = valuesSources;
            this.values = bigArrays.newLongArray(1L, false);
            this.empty = new MissingHelper(bigArrays);
        }

        public void swap(long lhs, long rhs) {
            long tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
            this.empty.swap(lhs, rhs);
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            MultiGeoPointValues docGeoPointValues = this.valuesSources.getGeoPointField(GeoLineAggregationBuilder.POINT_FIELD.getPreferredName(), ctx);
            return (index, doc) -> {
                if (!docGeoPointValues.advanceExact(doc)) {
                    this.empty.markMissing(index);
                    return;
                }
                if (docGeoPointValues.docValueCount() > 1) {
                    throw new AggregationExecutionException("Encountered more than one geo_point value for a single document. Use a script to combine multiple geo_point-values-per-doc into a single value.");
                }
                if (index >= this.values.size()) {
                    this.values = this.bigArrays.grow(this.values, index + 1L);
                }
                GeoPoint point = docGeoPointValues.nextValue();
                int encodedLat = GeoEncodingUtils.encodeLatitude((double)point.lat());
                int encodedLon = GeoEncodingUtils.encodeLongitude((double)point.lon());
                long lonLat = (long)encodedLon << 32 | (long)encodedLat & 0xFFFFFFFFL;
                this.values.set(index, lonLat);
                this.empty.markNotMissing(index);
            };
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.values, this.empty});
        }
    }
}

