/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.tree;

import java.util.Objects;
import org.elasticsearch.xpack.ql.tree.Location;

public final class Source {
    public static final Source EMPTY = new Source(Location.EMPTY, "");
    private final Location location;
    private final String text;

    public Source(int line, int charPositionInLine, String text) {
        this(new Location(line, charPositionInLine), text);
    }

    public Source(Location location, String text) {
        this.location = location;
        this.text = text;
    }

    public Location source() {
        return this.location;
    }

    public String text() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.text);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.text, other.text);
    }

    public String toString() {
        return this.text + this.location;
    }

    public static Source synthetic(String text) {
        return new Source(Location.EMPTY, text);
    }
}

