/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;

public class LimitExec
extends UnaryExec
implements Unexecutable {
    private final Expression limit;

    public LimitExec(Source source, PhysicalPlan child, Expression limit) {
        super(source, child);
        this.limit = limit;
    }

    protected NodeInfo<LimitExec> info() {
        return NodeInfo.create((Node)this, LimitExec::new, (Object)this.child(), (Object)this.limit);
    }

    @Override
    protected LimitExec replaceChild(PhysicalPlan newChild) {
        return new LimitExec(this.source(), newChild, this.limit);
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limit, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LimitExec other = (LimitExec)obj;
        return Objects.equals(this.limit, other.limit) && Objects.equals(this.child(), other.child());
    }
}

