/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.plan.physical.LeafExec;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class CommandExec
extends LeafExec {
    private final Command command;

    public CommandExec(Source source, Command command) {
        super(source);
        this.command = command;
    }

    protected NodeInfo<CommandExec> info() {
        return NodeInfo.create((Node)this, CommandExec::new, (Object)this.command);
    }

    public Command command() {
        return this.command;
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        this.command.execute(session, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public List<Attribute> output() {
        return this.command.output();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.command);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CommandExec other = (CommandExec)obj;
        return Objects.equals(this.command, other.command);
    }
}

