/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class ShowColumns
extends Command {
    private final String catalog;
    private final String index;
    private final LikePattern pattern;
    private final boolean includeFrozen;

    public ShowColumns(Source source, String catalog, String index, LikePattern pattern, boolean includeFrozen) {
        super(source);
        this.catalog = catalog;
        this.index = index;
        this.pattern = pattern;
        this.includeFrozen = includeFrozen;
    }

    public String index() {
        return this.index;
    }

    public LikePattern pattern() {
        return this.pattern;
    }

    protected NodeInfo<ShowColumns> info() {
        return NodeInfo.create((Node)this, ShowColumns::new, (Object)this.catalog, (Object)this.index, (Object)this.pattern, (Object)this.includeFrozen);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(new FieldAttribute(this.source(), "column", (EsField)new KeywordEsField("column")), new FieldAttribute(this.source(), "type", (EsField)new KeywordEsField("type")), new FieldAttribute(this.source(), "mapping", (EsField)new KeywordEsField("mapping")));
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        String cat;
        String cluster = session.indexResolver().clusterName();
        String string = cat = Strings.hasText((String)this.catalog) ? this.catalog : session.configuration().catalog();
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        idx = Strings.hasText((String)cat) && !cat.equals(cluster) ? RemoteClusterAware.buildRemoteIndexName((String)cat, (String)idx) : idx;
        boolean withFrozen = this.includeFrozen || session.configuration().includeFrozen();
        session.indexResolver().resolveAsMergedMapping(idx, withFrozen, Collections.emptyMap(), ActionListener.wrap(indexResult -> {
            List<List<?>> rows = Collections.emptyList();
            if (indexResult.isValid()) {
                rows = new ArrayList();
                this.fillInRows(indexResult.get().mapping(), null, rows);
            }
            listener.onResponse((Object)this.of(session, rows));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void fillInRows(Map<String, EsField> mapping, String prefix, List<List<?>> rows) {
        for (Map.Entry<String, EsField> e : mapping.entrySet()) {
            EsField field = e.getValue();
            DataType dt = field.getDataType();
            String name = e.getKey();
            if (dt == null) continue;
            rows.add(Arrays.asList(prefix != null ? prefix + "." + name : name, SqlDataTypes.sqlType(dt).getName(), dt.typeName()));
            if (field.getProperties().isEmpty()) continue;
            String newPrefix = prefix != null ? prefix + "." + name : name;
            this.fillInRows(field.getProperties(), newPrefix, rows);
        }
    }

    public int hashCode() {
        return Objects.hash(this.index, this.pattern, this.includeFrozen);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowColumns other = (ShowColumns)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern) && this.includeFrozen == other.includeFrozen;
    }
}

