/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.http.AbstractHttpServerTransport;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.nio.HttpReadWriteHandler;
import org.elasticsearch.http.nio.NioHttpChannel;
import org.elasticsearch.http.nio.NioHttpServerChannel;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.Config;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioChannelHandler;
import org.elasticsearch.nio.NioGroup;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.nio.NioGroupFactory;
import org.elasticsearch.transport.nio.PageAllocator;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class NioHttpServerTransport
extends AbstractHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(NioHttpServerTransport.class);
    protected final PageAllocator pageAllocator;
    private final NioGroupFactory nioGroupFactory;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final int tcpKeepIdle;
    protected final int tcpKeepInterval;
    protected final int tcpKeepCount;
    protected final boolean reuseAddress;
    protected final int tcpSendBufferSize;
    protected final int tcpReceiveBufferSize;
    private volatile NioGroup nioGroup;
    private ChannelFactory<NioHttpServerChannel, NioHttpChannel> channelFactory;

    public NioHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, NioGroupFactory nioGroupFactory, ClusterSettings clusterSettings) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings);
        this.pageAllocator = new PageAllocator(pageCacheRecycler);
        this.nioGroupFactory = nioGroupFactory;
        ByteSizeValue maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        ByteSizeValue maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        ByteSizeValue maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        int pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.tcpNoDelay = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(settings);
        this.tcpKeepAlive = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(settings);
        this.tcpKeepIdle = (Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(settings);
        this.tcpKeepInterval = (Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(settings);
        this.tcpKeepCount = (Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(settings);
        this.reuseAddress = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(settings);
        this.tcpSendBufferSize = Math.toIntExact(((ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(settings)).getBytes());
        this.tcpReceiveBufferSize = Math.toIntExact(((ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(settings)).getBytes());
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], pipelining_max_events[{}]", (Object)maxChunkSize, (Object)maxHeaderSize, (Object)maxInitialLineLength, (Object)this.maxContentLength, (Object)pipeliningMaxEvents);
    }

    public Logger getLogger() {
        return logger;
    }

    protected void doStart() {
        boolean success = false;
        try {
            this.nioGroup = this.nioGroupFactory.getHttpGroup();
            this.channelFactory = this.channelFactory();
            this.bindServer();
            success = true;
        }
        catch (IOException e) {
            throw new ElasticsearchException((Throwable)e);
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected void stopInternal() {
        try {
            this.nioGroup.close();
        }
        catch (Exception e) {
            logger.warn("unexpected exception while stopping nio group", (Throwable)e);
        }
    }

    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws IOException {
        NioHttpServerChannel httpServerChannel = (NioHttpServerChannel)this.nioGroup.bindServerChannel(socketAddress, this.channelFactory);
        PlainActionFuture future = PlainActionFuture.newFuture();
        httpServerChannel.addBindListener(ActionListener.toBiConsumer((ActionListener)future));
        future.actionGet();
        return httpServerChannel;
    }

    protected ChannelFactory<NioHttpServerChannel, NioHttpChannel> channelFactory() {
        return new HttpChannelFactory();
    }

    protected void acceptChannel(NioSocketChannel socketChannel) {
        super.serverAcceptedChannel((HttpChannel)socketChannel);
    }

    private class HttpChannelFactory
    extends ChannelFactory<NioHttpServerChannel, NioHttpChannel> {
        private HttpChannelFactory() {
            super(NioHttpServerTransport.this.tcpNoDelay, NioHttpServerTransport.this.tcpKeepAlive, NioHttpServerTransport.this.tcpKeepIdle, NioHttpServerTransport.this.tcpKeepInterval, NioHttpServerTransport.this.tcpKeepCount, NioHttpServerTransport.this.reuseAddress, NioHttpServerTransport.this.tcpSendBufferSize, NioHttpServerTransport.this.tcpReceiveBufferSize);
        }

        public NioHttpChannel createChannel(NioSelector selector, SocketChannel channel, Config.Socket socketConfig) {
            NioHttpChannel httpChannel = new NioHttpChannel(channel);
            HttpReadWriteHandler handler = new HttpReadWriteHandler(httpChannel, NioHttpServerTransport.this, NioHttpServerTransport.this.handlingSettings, selector.getTaskScheduler(), () -> ((ThreadPool)NioHttpServerTransport.this.threadPool).relativeTimeInMillis());
            Consumer<Exception> exceptionHandler = e -> NioHttpServerTransport.this.onException(httpChannel, (Exception)e);
            BytesChannelContext context = new BytesChannelContext((NioSocketChannel)httpChannel, selector, socketConfig, exceptionHandler, (NioChannelHandler)handler, new InboundChannelBuffer((IntFunction)NioHttpServerTransport.this.pageAllocator));
            httpChannel.setContext((SocketChannelContext)context);
            return httpChannel;
        }

        public NioHttpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel, Config.ServerSocket socketConfig) {
            NioHttpServerChannel httpServerChannel = new NioHttpServerChannel(channel);
            Consumer<Exception> exceptionHandler = e -> NioHttpServerTransport.this.onServerException(httpServerChannel, e);
            Consumer<NioSocketChannel> acceptor = NioHttpServerTransport.this::acceptChannel;
            ServerChannelContext context = new ServerChannelContext((NioServerSocketChannel)httpServerChannel, (ChannelFactory)this, selector, socketConfig, acceptor, exceptionHandler);
            httpServerChannel.setContext(context);
            return httpServerChannel;
        }
    }
}

