/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit;

import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.zip.CRC32;
import org.elasticsearch.repositories.RepositoryVerificationException;

class RandomBlobContent {
    static final int BUFFER_SIZE = 8191;
    final byte[] buffer = new byte[8191];
    private final BooleanSupplier isCancelledSupplier;
    private final AtomicReference<Runnable> onLastRead;
    private final String repositoryName;

    RandomBlobContent(String repositoryName, long seed, BooleanSupplier isCancelledSupplier, Runnable onLastRead) {
        this.repositoryName = repositoryName;
        this.isCancelledSupplier = isCancelledSupplier;
        this.onLastRead = new AtomicReference<Runnable>(onLastRead);
        new Random(seed).nextBytes(this.buffer);
    }

    long getChecksum(long checksumRangeStart, long checksumRangeEnd) {
        assert (0L <= checksumRangeStart && checksumRangeStart <= checksumRangeEnd);
        CRC32 crc32 = new CRC32();
        long startBlock = checksumRangeStart / (long)this.buffer.length;
        long endBlock = (checksumRangeEnd - 1L) / (long)this.buffer.length;
        if (startBlock == endBlock) {
            crc32.update(this.buffer, Math.toIntExact(checksumRangeStart % (long)this.buffer.length), Math.toIntExact(checksumRangeEnd - checksumRangeStart));
        } else {
            int bufferStart = Math.toIntExact(checksumRangeStart % (long)this.buffer.length);
            crc32.update(this.buffer, bufferStart, this.buffer.length - bufferStart);
            for (long block = startBlock + 1L; block < endBlock; ++block) {
                crc32.update(this.buffer);
            }
            crc32.update(this.buffer, 0, Math.toIntExact((checksumRangeEnd - 1L) % (long)this.buffer.length) + 1);
        }
        return crc32.getValue();
    }

    void ensureNotCancelled(String position) {
        if (this.isCancelledSupplier.getAsBoolean()) {
            throw new RepositoryVerificationException(this.repositoryName, "blob upload cancelled at position [" + position + "]");
        }
    }

    void onLastRead() {
        Runnable runnable = this.onLastRead.getAndSet(null);
        if (runnable != null) {
            runnable.run();
        }
    }
}

