/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.util.Counter;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestMetadata;

public final class InferenceProcessorInfoExtractor {
    private static final String FOREACH_PROCESSOR_NAME = "foreach";
    private static final int MAX_INFERENCE_PROCESSOR_SEARCH_RECURSIONS = 10;

    private InferenceProcessorInfoExtractor() {
    }

    public static int countInferenceProcessors(ClusterState state) {
        Metadata metadata = state.getMetadata();
        if (metadata == null) {
            return 0;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)metadata.custom("ingest");
        if (ingestMetadata == null) {
            return 0;
        }
        Counter counter = Counter.newCounter();
        ingestMetadata.getPipelines().forEach((pipelineId, configuration) -> {
            Map configMap = configuration.getConfigAsMap();
            List processorConfigs = ConfigurationUtils.readList(null, null, (Map)configMap, (String)"processors");
            for (Map processorConfigWithKey : processorConfigs) {
                for (Map.Entry entry : processorConfigWithKey.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines((String)entry.getKey(), pipelineId, (Map)entry.getValue(), pam -> counter.addAndGet(1L), 0);
                }
            }
        });
        return (int)counter.get();
    }

    public static Map<String, Set<String>> pipelineIdsByModelIdsOrAliases(ClusterState state, Set<String> modelIds) {
        HashMap<String, Set<String>> pipelineIdsByModelIds = new HashMap<String, Set<String>>();
        Metadata metadata = state.metadata();
        if (metadata == null) {
            return pipelineIdsByModelIds;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)metadata.custom("ingest");
        if (ingestMetadata == null) {
            return pipelineIdsByModelIds;
        }
        ingestMetadata.getPipelines().forEach((pipelineId, configuration) -> {
            Map configMap = configuration.getConfigAsMap();
            List processorConfigs = ConfigurationUtils.readList(null, null, (Map)configMap, (String)"processors");
            for (Map processorConfigWithKey : processorConfigs) {
                for (Map.Entry entry : processorConfigWithKey.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines((String)entry.getKey(), pipelineId, (Map)entry.getValue(), pam -> {
                        if (modelIds.contains(((PipelineAndModel)pam).modelIdOrAlias)) {
                            pipelineIdsByModelIds.computeIfAbsent(((PipelineAndModel)pam).modelIdOrAlias, m -> new LinkedHashSet()).add(pipelineId);
                        }
                    }, 0);
                }
            }
        });
        return pipelineIdsByModelIds;
    }

    private static void addModelsAndPipelines(String processorType, String pipelineId, Map<String, Object> processorDefinition, Consumer<PipelineAndModel> handler, int level) {
        if (level > 10) {
            return;
        }
        if (processorType == null || processorDefinition == null) {
            return;
        }
        if ("inference".equals(processorType)) {
            String modelId = (String)processorDefinition.get("model_id");
            if (modelId != null) {
                handler.accept(new PipelineAndModel(pipelineId, modelId));
            }
            return;
        }
        if (FOREACH_PROCESSOR_NAME.equals(processorType)) {
            Map innerProcessor = (Map)processorDefinition.get("processor");
            if (innerProcessor != null) {
                for (Map.Entry innerProcessorWithName : innerProcessor.entrySet()) {
                    InferenceProcessorInfoExtractor.addModelsAndPipelines((String)innerProcessorWithName.getKey(), pipelineId, (Map)innerProcessorWithName.getValue(), handler, level + 1);
                }
            }
            return;
        }
        if (processorDefinition.containsKey("on_failure")) {
            List onFailureConfigs = ConfigurationUtils.readList(null, null, processorDefinition, (String)"on_failure");
            onFailureConfigs.stream().flatMap(map -> map.entrySet().stream()).forEach(entry -> InferenceProcessorInfoExtractor.addModelsAndPipelines((String)entry.getKey(), pipelineId, (Map)entry.getValue(), handler, level + 1));
        }
    }

    private static class PipelineAndModel {
        private final String pipelineId;
        private final String modelIdOrAlias;

        private PipelineAndModel(String pipelineId, String modelIdOrAlias) {
            this.pipelineId = pipelineId;
            this.modelIdOrAlias = modelIdOrAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineAndModel that = (PipelineAndModel)o;
            return Objects.equals(this.pipelineId, that.pipelineId) && Objects.equals(this.modelIdOrAlias, that.modelIdOrAlias);
        }

        public int hashCode() {
            return Objects.hash(this.pipelineId, this.modelIdOrAlias);
        }
    }
}

