/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;

public class AnalysisFieldInfo
implements DataFrameAnalysis.FieldInfo {
    private final ExtractedFields extractedFields;

    AnalysisFieldInfo(ExtractedFields extractedFields) {
        this.extractedFields = Objects.requireNonNull(extractedFields);
    }

    public Set<String> getTypes(String field) {
        Optional<ExtractedField> extractedField = this.extractedFields.getAllFields().stream().filter(f -> f.getName().equals(field)).findAny();
        return extractedField.isPresent() ? extractedField.get().getTypes() : null;
    }

    public Long getCardinality(String field) {
        return this.extractedFields.getCardinalitiesForFieldsWithConstraints().get(field);
    }
}

