/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleFeatureSetUsage;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;

public class IndexLifecycleFeatureSet
implements XPackFeatureSet {
    private ClusterService clusterService;

    @Inject
    public IndexLifecycleFeatureSet(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public String name() {
        return "ilm";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        Metadata metadata = this.clusterService.state().metadata();
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)metadata.custom("index_lifecycle");
        if (lifecycleMetadata != null) {
            HashMap policyUsage = new HashMap();
            metadata.indices().forEach(entry -> {
                String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(((IndexMetadata)entry.value).getSettings());
                Integer indicesManaged = (Integer)policyUsage.get(policyName);
                indicesManaged = indicesManaged == null ? Integer.valueOf(1) : Integer.valueOf(indicesManaged + 1);
                policyUsage.put(policyName, indicesManaged);
            });
            List policyStats = lifecycleMetadata.getPolicies().values().stream().map(policy -> {
                Map<String, IndexLifecycleFeatureSetUsage.PhaseStats> phaseStats = policy.getPhases().values().stream().map(phase -> {
                    IndexLifecycleFeatureSetUsage.ActionConfigStats.Builder configurations = IndexLifecycleFeatureSetUsage.ActionConfigStats.builder();
                    Stream<Object> actionStream = phase.getActions().keySet().stream();
                    if (policy.getType() instanceof TimeseriesLifecycleType && TimeseriesLifecycleType.shouldInjectMigrateStepForPhase((Phase)phase)) {
                        actionStream = Stream.concat(actionStream, Stream.of("migrate"));
                    }
                    String[] actionNames = (String[])actionStream.toArray(String[]::new);
                    phase.getActions().forEach((k, v) -> this.collectActionConfigurations((String)k, (LifecycleAction)v, configurations));
                    return new Tuple((Object)phase.getName(), (Object)new IndexLifecycleFeatureSetUsage.PhaseStats(phase.getMinimumAge(), actionNames, configurations.build()));
                }).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
                return new IndexLifecycleFeatureSetUsage.PolicyStats(phaseStats, policyUsage.getOrDefault(policy.getName(), 0).intValue());
            }).collect(Collectors.toList());
            listener.onResponse((Object)new IndexLifecycleFeatureSetUsage(policyStats));
        } else {
            listener.onResponse((Object)new IndexLifecycleFeatureSetUsage());
        }
    }

    private void collectActionConfigurations(String actionName, LifecycleAction action, IndexLifecycleFeatureSetUsage.ActionConfigStats.Builder consumer) {
        switch (actionName) {
            case "allocate": {
                AllocateAction allocateAction = (AllocateAction)action;
                consumer.setAllocateNumberOfReplicas(allocateAction.getNumberOfReplicas());
                break;
            }
            case "forcemerge": {
                ForceMergeAction forceMergeAction = (ForceMergeAction)action;
                consumer.setForceMergeMaxNumberOfSegments(Integer.valueOf(forceMergeAction.getMaxNumSegments()));
                break;
            }
            case "rollover": {
                RolloverAction rolloverAction = (RolloverAction)action;
                consumer.setRolloverMaxAge(rolloverAction.getMaxAge());
                consumer.setRolloverMaxDocs(rolloverAction.getMaxDocs());
                consumer.setRolloverMaxPrimaryShardSize(rolloverAction.getMaxPrimaryShardSize());
                consumer.setRolloverMaxSize(rolloverAction.getMaxSize());
                break;
            }
            case "set_priority": {
                SetPriorityAction setPriorityAction = (SetPriorityAction)action;
                consumer.setPriority(setPriorityAction.getRecoveryPriority());
                break;
            }
            case "shrink": {
                ShrinkAction shrinkAction = (ShrinkAction)action;
                consumer.setShrinkMaxPrimaryShardSize(shrinkAction.getMaxPrimaryShardSize());
                consumer.setShrinkNumberOfShards(shrinkAction.getNumberOfShards());
            }
        }
    }
}

