/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.graph.GraphFeatureSetUsage;
import org.elasticsearch.xpack.graph.Graph;

public class GraphFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public GraphFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.GRAPH_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "graph";
    }

    public boolean available() {
        return this.licenseState != null && Graph.GRAPH_FEATURE.checkWithoutTracking(this.licenseState);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new GraphFeatureSetUsage(this.available(), this.enabled()));
    }
}

