/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class LeafSearchLookup {
    private final LeafReaderContext ctx;
    private final LeafDocLookup docMap;
    private final SourceLookup sourceLookup;
    private final LeafStoredFieldsLookup fieldsLookup;
    private final Map<String, Object> asMap;

    public LeafSearchLookup(LeafReaderContext ctx, LeafDocLookup docMap, SourceLookup sourceLookup, LeafStoredFieldsLookup fieldsLookup) {
        this.ctx = ctx;
        this.docMap = docMap;
        this.sourceLookup = sourceLookup;
        this.fieldsLookup = fieldsLookup;
        HashMap asMap = new HashMap(4);
        asMap.put("doc", docMap);
        asMap.put("_doc", docMap);
        asMap.put("_source", sourceLookup);
        asMap.put("_fields", fieldsLookup);
        this.asMap = Collections.unmodifiableMap(asMap);
    }

    public Map<String, Object> asMap() {
        return this.asMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }

    public LeafStoredFieldsLookup fields() {
        return this.fieldsLookup;
    }

    public LeafDocLookup doc() {
        return this.docMap;
    }

    public void setDocument(int docId) {
        this.docMap.setDocument(docId);
        this.sourceLookup.setSegmentAndDocument(this.ctx, docId);
        this.fieldsLookup.setDocument(docId);
    }
}

