/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.net.InetAddress;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.index.fielddata.BinaryScriptFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class IpScriptFieldData
extends BinaryScriptFieldData {
    private final IpFieldScript.LeafFactory leafFactory;

    private IpScriptFieldData(String fieldName, IpFieldScript.LeafFactory leafFactory) {
        super(fieldName);
        this.leafFactory = leafFactory;
    }

    @Override
    public BinaryScriptFieldData.BinaryScriptLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        final IpFieldScript script = this.leafFactory.newInstance(context);
        return new BinaryScriptFieldData.BinaryScriptLeafFieldData(){

            public ScriptDocValues<String> getScriptValues() {
                return new IpScriptDocValues(this.getBytesValues());
            }

            @Override
            public SortedBinaryDocValues getBytesValues() {
                return new org.elasticsearch.index.fielddata.IpScriptDocValues(script);
            }
        };
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.IP;
    }

    public static class IpScriptDocValues
    extends ScriptDocValues.Strings {
        public IpScriptDocValues(SortedBinaryDocValues in) {
            super(in);
        }

        @Override
        protected String bytesToString(BytesRef bytes) {
            InetAddress addr = InetAddressPoint.decode((byte[])BytesReference.toBytes(new BytesArray(bytes)));
            return InetAddresses.toAddrString(addr);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final IpFieldScript.LeafFactory leafFactory;

        public Builder(String name, IpFieldScript.LeafFactory leafFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
        }

        public IpScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new IpScriptFieldData(this.name, this.leafFactory);
        }
    }
}

