/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;

public interface ZenPing
extends Releasable {
    public void start();

    public void ping(Consumer<PingCollection> var1, TimeValue var2);

    public static class PingCollection {
        Map<DiscoveryNode, PingResponse> pings = new HashMap<DiscoveryNode, PingResponse>();

        public synchronized boolean addPing(PingResponse ping) {
            PingResponse existingResponse = this.pings.get(ping.node());
            if (existingResponse == null || existingResponse.id() <= ping.id()) {
                this.pings.put(ping.node(), ping);
                return true;
            }
            return false;
        }

        public synchronized List<PingResponse> toList() {
            return new ArrayList<PingResponse>(this.pings.values());
        }

        public synchronized int size() {
            return this.pings.size();
        }
    }

    public static class PingResponse
    implements Writeable {
        public static long FAKE_PING_ID = -1L;
        private static final AtomicLong idGenerator = new AtomicLong();
        private final long id;
        private final ClusterName clusterName;
        private final DiscoveryNode node;
        private final DiscoveryNode master;
        private final long clusterStateVersion;

        public PingResponse(DiscoveryNode node, DiscoveryNode master, ClusterName clusterName, long clusterStateVersion) {
            this(idGenerator.incrementAndGet(), node, master, clusterName, clusterStateVersion);
        }

        public PingResponse(long id, DiscoveryNode node, DiscoveryNode master, ClusterName clusterName, long clusterStateVersion) {
            this.id = id;
            this.node = node;
            this.master = master;
            this.clusterName = clusterName;
            this.clusterStateVersion = clusterStateVersion;
        }

        public PingResponse(DiscoveryNode node, DiscoveryNode master, ClusterState state) {
            this(node, master, state.getClusterName(), state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK) ? -1L : state.version());
        }

        PingResponse(StreamInput in) throws IOException {
            this.clusterName = new ClusterName(in);
            this.node = new DiscoveryNode(in);
            this.master = in.readOptionalWriteable(DiscoveryNode::new);
            this.clusterStateVersion = in.readLong();
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            this.node.writeTo(out);
            out.writeOptionalWriteable(this.master);
            out.writeLong(this.clusterStateVersion);
            out.writeLong(this.id);
        }

        public long id() {
            return this.id;
        }

        public ClusterName clusterName() {
            return this.clusterName;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public DiscoveryNode master() {
            return this.master;
        }

        public long getClusterStateVersion() {
            return this.clusterStateVersion;
        }

        public String toString() {
            return "ping_response{node [" + this.node + "], id[" + this.id + "], master [" + this.master + "],cluster_state_version [" + this.clusterStateVersion + "], cluster_name[" + this.clusterName.value() + "]}";
        }
    }
}

