/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master.info;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.action.support.master.info.ClusterInfoRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportClusterInfoAction<Request extends ClusterInfoRequest<Request>, Response extends ActionResponse>
extends TransportMasterNodeReadAction<Request, Response> {
    public TransportClusterInfoAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Response> response) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, request, indexNameExpressionResolver, response, "management");
    }

    @Override
    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    @Override
    protected final void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected final void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
        this.doMasterOperation(task, request, concreteIndices, state, listener);
    }

    protected abstract void doMasterOperation(Task var1, Request var2, String[] var3, ClusterState var4, ActionListener<Response> var5);
}

