/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class ContextPreservingActionListener<R>
extends ActionListener.Delegating<R, R> {
    private final Supplier<ThreadContext.StoredContext> context;

    public ContextPreservingActionListener(Supplier<ThreadContext.StoredContext> contextSupplier, ActionListener<R> delegate) {
        super(delegate);
        this.context = contextSupplier;
    }

    @Override
    public void onResponse(R r) {
        try (ThreadContext.StoredContext ignore = this.context.get();){
            this.delegate.onResponse(r);
        }
    }

    @Override
    public void onFailure(Exception e) {
        try (ThreadContext.StoredContext ignore = this.context.get();){
            this.delegate.onFailure(e);
        }
    }

    public static <R> ContextPreservingActionListener<R> wrapPreservingContext(ActionListener<R> listener, ThreadContext threadContext) {
        return new ContextPreservingActionListener<R>(threadContext.newRestorableContext(true), listener);
    }
}

