/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceGroup;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.UntilGroup;

class KeyToSequences
implements Accountable {
    private final int listSize;
    private final Map<SequenceKey, SequenceEntry> keyToSequences;

    KeyToSequences(int listSize) {
        this.listSize = listSize;
        this.keyToSequences = new LinkedHashMap<SequenceKey, SequenceEntry>();
    }

    SequenceGroup groupIfPresent(int stage, SequenceKey key) {
        SequenceEntry sequenceEntry = this.keyToSequences.get(key);
        return sequenceEntry == null ? null : sequenceEntry.groups[stage];
    }

    UntilGroup untilIfPresent(SequenceKey key) {
        SequenceEntry sequenceEntry = this.keyToSequences.get(key);
        return sequenceEntry == null ? null : sequenceEntry.until;
    }

    void add(int stage, Sequence sequence) {
        SequenceKey key = sequence.key();
        SequenceEntry info = this.keyToSequences.computeIfAbsent(key, k -> new SequenceEntry(this.listSize));
        info.add(stage, sequence);
    }

    void until(Iterable<KeyAndOrdinal> until) {
        for (KeyAndOrdinal keyAndOrdinal : until) {
            SequenceKey key = keyAndOrdinal.key();
            SequenceEntry sequenceEntry = this.keyToSequences.get(key);
            if (sequenceEntry == null) continue;
            sequenceEntry.until(keyAndOrdinal.ordinal);
        }
    }

    void remove(int stage, SequenceKey key) {
        SequenceEntry info = this.keyToSequences.get(key);
        info.remove(stage);
    }

    void trimToTail(Ordinal ordinal) {
        Iterator<SequenceEntry> it = this.keyToSequences.values().iterator();
        while (it.hasNext()) {
            UntilGroup until;
            SequenceEntry seqs = it.next();
            Sequence firstTail = null;
            boolean keyIsEmpty = true;
            for (SequenceGroup group : seqs.groups) {
                if (group == null) continue;
                Sequence sequence = (Sequence)group.trimBeforeLast(ordinal);
                if (firstTail == null) {
                    firstTail = sequence;
                }
                keyIsEmpty &= group.isEmpty();
            }
            if (keyIsEmpty) {
                it.remove();
            }
            if (firstTail == null || (until = seqs.until) == null) continue;
            until.trimBefore(firstTail.ordinal());
        }
    }

    public void clear() {
        this.keyToSequences.clear();
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOfMap(this.keyToSequences);
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"Keys=[{}]", (Object[])new Object[]{this.keyToSequences.size()});
    }

    private static class SequenceEntry
    implements Accountable {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(SequenceEntry.class);
        private final SequenceGroup[] groups;
        private UntilGroup until;

        SequenceEntry(int stages) {
            this.groups = new SequenceGroup[stages];
        }

        void add(int stage, Sequence sequence) {
            if (this.groups[stage] == null) {
                this.groups[stage] = new SequenceGroup();
            }
            this.groups[stage].add(sequence);
        }

        public void remove(int stage) {
            this.groups[stage] = null;
        }

        void until(Ordinal ordinal) {
            if (this.until == null) {
                this.until = new UntilGroup();
            }
            this.until.add(ordinal);
        }

        public long ramBytesUsed() {
            long size = SHALLOW_SIZE;
            if (this.until != null) {
                size += this.until.ramBytesUsed();
            }
            return size += RamUsageEstimator.sizeOf((Accountable[])this.groups);
        }
    }
}

