/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.pagerduty;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.actions.pagerduty.PagerDutyAction;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEvent;
import org.elasticsearch.xpack.watcher.notification.pagerduty.PagerDutyAccount;
import org.elasticsearch.xpack.watcher.notification.pagerduty.PagerDutyService;
import org.elasticsearch.xpack.watcher.notification.pagerduty.SentEvent;
import org.elasticsearch.xpack.watcher.support.Variables;

public class ExecutablePagerDutyAction
extends ExecutableAction<PagerDutyAction> {
    private final TextTemplateEngine templateEngine;
    private final PagerDutyService pagerDutyService;

    public ExecutablePagerDutyAction(PagerDutyAction action, Logger logger, PagerDutyService pagerDutyService, TextTemplateEngine templateEngine) {
        super((Action)action, logger);
        this.pagerDutyService = pagerDutyService;
        this.templateEngine = templateEngine;
    }

    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        PagerDutyAccount account = (PagerDutyAccount)this.pagerDutyService.getAccount(((PagerDutyAction)this.action).event.account);
        if (account == null) {
            throw new IllegalStateException("account [" + ((PagerDutyAction)this.action).event.account + "] was not found. perhaps it was deleted");
        }
        Map<String, Object> model = Variables.createCtxParamsMap(ctx, payload);
        IncidentEvent event = ((PagerDutyAction)this.action).event.render(ctx.watch().id(), actionId, this.templateEngine, model, account.getDefaults());
        if (ctx.simulateAction(actionId)) {
            return new PagerDutyAction.Result.Simulated(event);
        }
        SentEvent sentEvent = account.send(event, payload, ctx.id().watchId());
        return new PagerDutyAction.Result.Executed(account.getName(), sentEvent);
    }
}

