/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.preallocate;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.searchablesnapshots.preallocate.Preallocator;

final class MacOsPreallocator
implements Preallocator {
    MacOsPreallocator() {
    }

    @Override
    public boolean useNative() {
        return Natives.NATIVES_AVAILABLE;
    }

    @Override
    public int preallocate(int fd, long currentSize, long fileSize) {
        Natives.Fcntl.FStore fst = AccessController.doPrivileged(Natives.Fcntl.FStore::new);
        fst.fst_flags = 2;
        fst.fst_posmode = 3;
        fst.fst_offset = new NativeLong(0L);
        fst.fst_length = new NativeLong(fileSize);
        if (Natives.fcntl(fd, 42, fst) != 0) {
            fst.fst_flags = 4;
            if (Natives.fcntl(fd, 42, fst) != 0) {
                return Native.getLastError();
            }
        }
        if (Natives.ftruncate(fd, new NativeLong(fileSize)) != 0) {
            return Native.getLastError();
        }
        return 0;
    }

    @Override
    public String error(int errno) {
        return Natives.strerror(errno);
    }

    private static class Natives {
        static boolean NATIVES_AVAILABLE = AccessController.doPrivileged(() -> {
            try {
                Native.register(Natives.class, (String)Platform.C_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError e) {
                return false;
            }
            return true;
        });

        private Natives() {
        }

        static native int fcntl(int var0, int var1, Fcntl.FStore var2);

        static native int ftruncate(int var0, NativeLong var1);

        static native String strerror(int var0);

        static class Fcntl {
            private static final int F_PREALLOCATE = 42;
            private static final int F_ALLOCATECONTIG = 2;
            private static final int F_ALLOCATEALL = 4;
            private static final int F_PEOFPOSMODE = 3;
            private static final int F_VOLPOSMODE = 4;

            Fcntl() {
            }

            public static final class FStore
            extends Structure
            implements Structure.ByReference {
                public int fst_flags = 0;
                public int fst_posmode = 0;
                public NativeLong fst_offset = new NativeLong(0L);
                public NativeLong fst_length = new NativeLong(0L);
                public NativeLong fst_bytesalloc = new NativeLong(0L);

                protected List<String> getFieldOrder() {
                    return Arrays.asList("fst_flags", "fst_posmode", "fst_offset", "fst_length", "fst_bytesalloc");
                }
            }
        }
    }
}

