/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.bulk;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.transport.RawIndexingDataTransportRequest;

public final class BulkShardOperationsRequest
extends ReplicatedWriteRequest<BulkShardOperationsRequest>
implements RawIndexingDataTransportRequest {
    private final String historyUUID;
    private final List<Translog.Operation> operations;
    private final long maxSeqNoOfUpdatesOrDeletes;

    public BulkShardOperationsRequest(StreamInput in) throws IOException {
        super(in);
        this.historyUUID = in.readString();
        this.maxSeqNoOfUpdatesOrDeletes = in.readZLong();
        this.operations = in.readList(Translog.Operation::readOperation);
    }

    public BulkShardOperationsRequest(ShardId shardId, String historyUUID, List<Translog.Operation> operations, long maxSeqNoOfUpdatesOrDeletes) {
        super(shardId);
        this.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
        this.historyUUID = historyUUID;
        this.operations = operations;
        this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
    }

    public String getHistoryUUID() {
        return this.historyUUID;
    }

    public List<Translog.Operation> getOperations() {
        return this.operations;
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.maxSeqNoOfUpdatesOrDeletes;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.historyUUID);
        out.writeZLong(this.maxSeqNoOfUpdatesOrDeletes);
        out.writeVInt(this.operations.size());
        for (Translog.Operation operation : this.operations) {
            Translog.Operation.writeOperation((StreamOutput)out, (Translog.Operation)operation);
        }
    }

    public String toString() {
        return "BulkShardOperationsRequest{historyUUID=" + this.historyUUID + ", operations=" + this.operations.size() + ", maxSeqNoUpdates=" + this.maxSeqNoOfUpdatesOrDeletes + ", shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + '\'' + ", waitForActiveShards=" + this.waitForActiveShards + '}';
    }
}

