/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.trigger;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;

public abstract class TriggerEvent
implements ToXContentObject {
    private final String jobName;
    protected final ZonedDateTime triggeredTime;
    protected final Map<String, Object> data;

    public TriggerEvent(String jobName, ZonedDateTime triggeredTime) {
        this.jobName = jobName;
        this.triggeredTime = triggeredTime;
        this.data = new HashMap<String, Object>();
        this.data.put(Field.TRIGGERED_TIME.getPreferredName(), new JodaCompatibleZonedDateTime(triggeredTime.toInstant(), (ZoneId)ZoneOffset.UTC));
    }

    public String jobName() {
        return this.jobName;
    }

    public abstract String type();

    public ZonedDateTime triggeredTime() {
        return this.triggeredTime;
    }

    public final Map<String, Object> data() {
        return this.data;
    }

    public String toString() {
        return "[" + "name=[" + this.jobName + "]," + "triggered_time=[" + this.triggeredTime + "]," + "data=[" + this.data + "]" + "]";
    }

    public void recordXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.TYPE.getPreferredName(), this.type());
        WatcherDateTimeUtils.writeDate(Field.TRIGGERED_TIME.getPreferredName(), builder, this.triggeredTime);
        this.recordDataXContent(builder, params);
        builder.endObject();
    }

    public abstract void recordDataXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    protected static interface Field {
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField TRIGGERED_TIME = new ParseField("triggered_time", new String[0]);
    }
}

