/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.util.Locale;
import javax.net.ssl.SSLParameters;

public abstract class SSLClientAuth
extends Enum<SSLClientAuth> {
    public static final /* enum */ SSLClientAuth NONE = new SSLClientAuth(){

        @Override
        public boolean enabled() {
            return false;
        }

        @Override
        public void configure(SSLParameters sslParameters) {
            assert (!sslParameters.getWantClientAuth());
            assert (!sslParameters.getNeedClientAuth());
        }
    };
    public static final /* enum */ SSLClientAuth OPTIONAL = new SSLClientAuth(){

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public void configure(SSLParameters sslParameters) {
            sslParameters.setWantClientAuth(true);
        }
    };
    public static final /* enum */ SSLClientAuth REQUIRED = new SSLClientAuth(){

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public void configure(SSLParameters sslParameters) {
            sslParameters.setNeedClientAuth(true);
        }
    };
    private static final /* synthetic */ SSLClientAuth[] $VALUES;

    public static SSLClientAuth[] values() {
        return (SSLClientAuth[])$VALUES.clone();
    }

    public static SSLClientAuth valueOf(String name) {
        return Enum.valueOf(SSLClientAuth.class, name);
    }

    public abstract boolean enabled();

    public abstract void configure(SSLParameters var1);

    public static SSLClientAuth parse(String value) {
        assert (value != null);
        switch (value.toLowerCase(Locale.ROOT)) {
            case "none": {
                return NONE;
            }
            case "optional": {
                return OPTIONAL;
            }
            case "required": {
                return REQUIRED;
            }
        }
        throw new IllegalArgumentException("could not resolve ssl client auth. unknown value [" + value + "]");
    }

    private static /* synthetic */ SSLClientAuth[] $values() {
        return new SSLClientAuth[]{NONE, OPTIONAL, REQUIRED};
    }

    static {
        $VALUES = SSLClientAuth.$values();
    }
}

