/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.support.CacheKey;

public class IndicesAccessControl {
    public static final IndicesAccessControl ALLOW_NO_INDICES = new IndicesAccessControl(true, Collections.singletonMap("-*", new IndexAccessControl(true, new FieldPermissions(), DocumentPermissions.allowAll())));
    public static final IndicesAccessControl DENIED = new IndicesAccessControl(false, Collections.emptyMap());
    private final boolean granted;
    private final Map<String, IndexAccessControl> indexPermissions;

    public IndicesAccessControl(boolean granted, Map<String, IndexAccessControl> indexPermissions) {
        this.granted = granted;
        this.indexPermissions = Objects.requireNonNull(indexPermissions);
    }

    @Nullable
    public IndexAccessControl getIndexPermissions(String index) {
        return this.indexPermissions.get(index);
    }

    public boolean isGranted() {
        return this.granted;
    }

    public Collection<?> getDeniedIndices() {
        return Collections.unmodifiableSet(this.indexPermissions.entrySet().stream().filter(e -> !((IndexAccessControl)e.getValue()).granted).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    public DlsFlsUsage getFieldAndDocumentLevelSecurityUsage() {
        boolean hasFls = false;
        boolean hasDls = false;
        for (IndexAccessControl iac : this.indexPermissions.values()) {
            if (iac.fieldPermissions.hasFieldLevelSecurity()) {
                hasFls = true;
            }
            if (iac.documentPermissions.hasDocumentLevelPermissions()) {
                hasDls = true;
            }
            if (!hasFls || !hasDls) continue;
            return DlsFlsUsage.BOTH;
        }
        if (hasFls) {
            return DlsFlsUsage.FLS;
        }
        if (hasDls) {
            return DlsFlsUsage.DLS;
        }
        return DlsFlsUsage.NONE;
    }

    public List<String> getIndicesWithFieldOrDocumentLevelSecurity() {
        return this.getIndexNames(iac -> ((IndexAccessControl)iac).fieldPermissions.hasFieldLevelSecurity() || ((IndexAccessControl)iac).documentPermissions.hasDocumentLevelPermissions());
    }

    public List<String> getIndicesWithFieldLevelSecurity() {
        return this.getIndexNames(iac -> ((IndexAccessControl)iac).fieldPermissions.hasFieldLevelSecurity());
    }

    public List<String> getIndicesWithDocumentLevelSecurity() {
        return this.getIndexNames(iac -> ((IndexAccessControl)iac).documentPermissions.hasDocumentLevelPermissions());
    }

    private List<String> getIndexNames(Predicate<IndexAccessControl> predicate) {
        return this.indexPermissions.entrySet().stream().filter(entry -> predicate.test((IndexAccessControl)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public IndicesAccessControl limitIndicesAccessControl(IndicesAccessControl limitedByIndicesAccessControl) {
        if (this instanceof AllowAllIndicesAccessControl) {
            return limitedByIndicesAccessControl;
        }
        if (limitedByIndicesAccessControl instanceof AllowAllIndicesAccessControl) {
            return this;
        }
        boolean isGranted = this.granted == limitedByIndicesAccessControl.granted ? this.granted : false;
        Set<String> indexes = this.indexPermissions.keySet();
        Set<String> otherIndexes = limitedByIndicesAccessControl.indexPermissions.keySet();
        Set commonIndexes = Sets.intersection(indexes, otherIndexes);
        HashMap<String, IndexAccessControl> indexPermissionsMap = new HashMap<String, IndexAccessControl>(commonIndexes.size());
        for (String index : commonIndexes) {
            IndexAccessControl indexAccessControl = this.getIndexPermissions(index);
            IndexAccessControl limitedByIndexAccessControl = limitedByIndicesAccessControl.getIndexPermissions(index);
            indexPermissionsMap.put(index, indexAccessControl.limitIndexAccessControl(limitedByIndexAccessControl));
        }
        return new IndicesAccessControl(isGranted, indexPermissionsMap);
    }

    public String toString() {
        return "IndicesAccessControl{granted=" + this.granted + ", indexPermissions=" + this.indexPermissions + '}';
    }

    public static IndicesAccessControl allowAll() {
        return AllowAllIndicesAccessControl.INSTANCE;
    }

    public static class IndexAccessControl
    implements CacheKey {
        private final boolean granted;
        private final FieldPermissions fieldPermissions;
        private final DocumentPermissions documentPermissions;

        public IndexAccessControl(boolean granted, FieldPermissions fieldPermissions, DocumentPermissions documentPermissions) {
            this.granted = granted;
            this.fieldPermissions = fieldPermissions == null ? FieldPermissions.DEFAULT : fieldPermissions;
            this.documentPermissions = documentPermissions == null ? DocumentPermissions.allowAll() : documentPermissions;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        @Nullable
        public DocumentPermissions getDocumentPermissions() {
            return this.documentPermissions;
        }

        public IndexAccessControl limitIndexAccessControl(IndexAccessControl limitedByIndexAccessControl) {
            boolean isGranted = this.granted == limitedByIndexAccessControl.granted ? this.granted : false;
            FieldPermissions constrainedFieldPermissions = this.getFieldPermissions().limitFieldPermissions(limitedByIndexAccessControl.fieldPermissions);
            DocumentPermissions constrainedDocumentPermissions = this.getDocumentPermissions().limitDocumentPermissions(limitedByIndexAccessControl.getDocumentPermissions());
            return new IndexAccessControl(isGranted, constrainedFieldPermissions, constrainedDocumentPermissions);
        }

        public String toString() {
            return "IndexAccessControl{granted=" + this.granted + ", fieldPermissions=" + this.fieldPermissions + ", documentPermissions=" + this.documentPermissions + '}';
        }

        @Override
        public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
            if (this.documentPermissions.hasDocumentLevelPermissions()) {
                out.writeBoolean(true);
                this.documentPermissions.buildCacheKey(out, context);
            } else {
                out.writeBoolean(false);
            }
            if (this.fieldPermissions.hasFieldLevelSecurity()) {
                out.writeBoolean(true);
                this.fieldPermissions.buildCacheKey(out, context);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexAccessControl that = (IndexAccessControl)o;
            return this.granted == that.granted && Objects.equals(this.fieldPermissions, that.fieldPermissions) && Objects.equals(this.documentPermissions, that.documentPermissions);
        }

        public int hashCode() {
            return Objects.hash(this.granted, this.fieldPermissions, this.documentPermissions);
        }
    }

    public static enum DlsFlsUsage {
        NONE,
        DLS{

            @Override
            public boolean hasDocumentLevelSecurity() {
                return true;
            }
        }
        ,
        FLS{

            @Override
            public boolean hasFieldLevelSecurity() {
                return true;
            }
        }
        ,
        BOTH{

            @Override
            public boolean hasFieldLevelSecurity() {
                return true;
            }

            @Override
            public boolean hasDocumentLevelSecurity() {
                return true;
            }
        };


        public boolean hasFieldLevelSecurity() {
            return false;
        }

        public boolean hasDocumentLevelSecurity() {
            return false;
        }
    }

    private static class AllowAllIndicesAccessControl
    extends IndicesAccessControl {
        private static final IndicesAccessControl INSTANCE = new AllowAllIndicesAccessControl();
        private final IndexAccessControl allowAllIndexAccessControl = new IndexAccessControl(true, null, null);

        private AllowAllIndicesAccessControl() {
            super(true, org.elasticsearch.core.Map.of());
        }

        @Override
        public IndexAccessControl getIndexPermissions(String index) {
            return this.allowAllIndexAccessControl;
        }

        @Override
        public String toString() {
            return "AllowAllIndicesAccessControl{}";
        }
    }
}

