/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class Job
extends AbstractDiffable<Job>
implements Writeable,
ToXContentObject {
    public static final String TYPE = "job";
    public static final String ANOMALY_DETECTOR_JOB_TYPE = "anomaly_detector";
    public static final ParseField ID = new ParseField("job_id", new String[0]);
    public static final ParseField JOB_TYPE = new ParseField("job_type", new String[0]);
    public static final ParseField JOB_VERSION = new ParseField("job_version", new String[0]);
    public static final ParseField GROUPS = new ParseField("groups", new String[0]);
    public static final ParseField ANALYSIS_CONFIG = AnalysisConfig.ANALYSIS_CONFIG;
    public static final ParseField ANALYSIS_LIMITS = new ParseField("analysis_limits", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField CUSTOM_SETTINGS = new ParseField("custom_settings", new String[0]);
    public static final ParseField DATA_DESCRIPTION = new ParseField("data_description", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField FINISHED_TIME = new ParseField("finished_time", new String[0]);
    public static final ParseField MODEL_PLOT_CONFIG = new ParseField("model_plot_config", new String[0]);
    public static final ParseField RENORMALIZATION_WINDOW_DAYS = new ParseField("renormalization_window_days", new String[0]);
    public static final ParseField BACKGROUND_PERSIST_INTERVAL = new ParseField("background_persist_interval", new String[0]);
    public static final ParseField MODEL_SNAPSHOT_RETENTION_DAYS = new ParseField("model_snapshot_retention_days", new String[0]);
    public static final ParseField DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS = new ParseField("daily_model_snapshot_retention_after_days", new String[0]);
    public static final ParseField RESULTS_RETENTION_DAYS = new ParseField("results_retention_days", new String[0]);
    public static final ParseField MODEL_SNAPSHOT_ID = new ParseField("model_snapshot_id", new String[0]);
    public static final ParseField MODEL_SNAPSHOT_MIN_VERSION = new ParseField("model_snapshot_min_version", new String[0]);
    public static final ParseField RESULTS_INDEX_NAME = new ParseField("results_index_name", new String[0]);
    public static final ParseField DELETING = new ParseField("deleting", new String[0]);
    public static final ParseField ALLOW_LAZY_OPEN = new ParseField("allow_lazy_open", new String[0]);
    public static final ParseField BLOCKED = new ParseField("blocked", new String[0]);
    public static final ParseField DATAFEED_CONFIG = new ParseField("datafeed_config", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("jobs", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = Job.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = Job.createParser(false);
    public static final TimeValue MIN_BACKGROUND_PERSIST_INTERVAL = TimeValue.timeValueHours((long)1L);
    public static final ByteSizeValue PROCESS_MEMORY_OVERHEAD = ByteSizeValue.ofMb((long)10L);
    public static final long DEFAULT_MODEL_SNAPSHOT_RETENTION_DAYS = 10L;
    public static final long DEFAULT_DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS = 1L;
    private final String jobId;
    private final String jobType;
    @Nullable
    private final Version jobVersion;
    private final List<String> groups;
    private final String description;
    private final Date createTime;
    private final Date finishedTime;
    private final AnalysisConfig analysisConfig;
    private final AnalysisLimits analysisLimits;
    private final DataDescription dataDescription;
    private final ModelPlotConfig modelPlotConfig;
    private final Long renormalizationWindowDays;
    private final TimeValue backgroundPersistInterval;
    private final Long modelSnapshotRetentionDays;
    private final Long dailyModelSnapshotRetentionAfterDays;
    private final Long resultsRetentionDays;
    private final Map<String, Object> customSettings;
    private final String modelSnapshotId;
    private final Version modelSnapshotMinVersion;
    private final String resultsIndexName;
    private final boolean deleting;
    private final boolean allowLazyOpen;
    private final Blocked blocked;
    private final DatafeedConfig datafeedConfig;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser("job_details", ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setId, ID);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setJobType(x$0), JOB_TYPE);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setJobVersion(x$0), JOB_VERSION);
        parser.declareStringArray(Builder::setGroups, GROUPS);
        parser.declareStringOrNull(Builder::setDescription, DESCRIPTION);
        parser.declareField(Builder::setCreateTime, p -> TimeUtils.parseTimeField(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::setFinishedTime, p -> TimeUtils.parseTimeField(p, FINISHED_TIME.getPreferredName()), FINISHED_TIME, ObjectParser.ValueType.VALUE);
        parser.declareObject(Builder::setAnalysisConfig, ignoreUnknownFields ? AnalysisConfig.LENIENT_PARSER : AnalysisConfig.STRICT_PARSER, ANALYSIS_CONFIG);
        parser.declareObject(Builder::setAnalysisLimits, ignoreUnknownFields ? AnalysisLimits.LENIENT_PARSER : AnalysisLimits.STRICT_PARSER, ANALYSIS_LIMITS);
        parser.declareObject(Builder::setDataDescription, ignoreUnknownFields ? DataDescription.LENIENT_PARSER : DataDescription.STRICT_PARSER, DATA_DESCRIPTION);
        parser.declareObject(Builder::setModelPlotConfig, ignoreUnknownFields ? ModelPlotConfig.LENIENT_PARSER : ModelPlotConfig.STRICT_PARSER, MODEL_PLOT_CONFIG);
        parser.declareLong(Builder::setRenormalizationWindowDays, RENORMALIZATION_WINDOW_DAYS);
        parser.declareString((builder, val) -> builder.setBackgroundPersistInterval(TimeValue.parseTimeValue((String)val, (String)BACKGROUND_PERSIST_INTERVAL.getPreferredName())), BACKGROUND_PERSIST_INTERVAL);
        parser.declareLong(Builder::setResultsRetentionDays, RESULTS_RETENTION_DAYS);
        parser.declareLong(Builder::setModelSnapshotRetentionDays, MODEL_SNAPSHOT_RETENTION_DAYS);
        parser.declareLong(Builder::setDailyModelSnapshotRetentionAfterDays, DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS);
        parser.declareField(Builder::setCustomSettings, (p, c) -> p.mapOrdered(), CUSTOM_SETTINGS, ObjectParser.ValueType.OBJECT);
        parser.declareStringOrNull(Builder::setModelSnapshotId, MODEL_SNAPSHOT_ID);
        parser.declareStringOrNull(Builder::setModelSnapshotMinVersion, MODEL_SNAPSHOT_MIN_VERSION);
        parser.declareString(Builder::setResultsIndexName, RESULTS_INDEX_NAME);
        parser.declareBoolean(Builder::setDeleting, DELETING);
        parser.declareBoolean(Builder::setAllowLazyOpen, ALLOW_LAZY_OPEN);
        parser.declareObject(Builder::setBlocked, ignoreUnknownFields ? Blocked.LENIENT_PARSER : Blocked.STRICT_PARSER, BLOCKED);
        parser.declareObject(Builder::setDatafeed, ignoreUnknownFields ? DatafeedConfig.LENIENT_PARSER : DatafeedConfig.STRICT_PARSER, DATAFEED_CONFIG);
        return parser;
    }

    private Job(String jobId, String jobType, Version jobVersion, List<String> groups, String description, Date createTime, Date finishedTime, AnalysisConfig analysisConfig, AnalysisLimits analysisLimits, DataDescription dataDescription, ModelPlotConfig modelPlotConfig, Long renormalizationWindowDays, TimeValue backgroundPersistInterval, Long modelSnapshotRetentionDays, Long dailyModelSnapshotRetentionAfterDays, Long resultsRetentionDays, Map<String, Object> customSettings, String modelSnapshotId, Version modelSnapshotMinVersion, String resultsIndexName, boolean deleting, boolean allowLazyOpen, Blocked blocked, DatafeedConfig datafeedConfig) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobVersion = jobVersion;
        this.groups = Collections.unmodifiableList(groups);
        this.description = description;
        this.createTime = createTime;
        this.finishedTime = finishedTime;
        this.analysisConfig = analysisConfig;
        this.analysisLimits = analysisLimits;
        this.dataDescription = dataDescription;
        this.modelPlotConfig = modelPlotConfig;
        this.renormalizationWindowDays = renormalizationWindowDays;
        this.backgroundPersistInterval = backgroundPersistInterval;
        this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
        this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
        this.resultsRetentionDays = resultsRetentionDays;
        this.customSettings = customSettings == null ? null : Collections.unmodifiableMap(customSettings);
        this.modelSnapshotId = modelSnapshotId;
        this.modelSnapshotMinVersion = modelSnapshotMinVersion;
        this.resultsIndexName = resultsIndexName;
        this.allowLazyOpen = allowLazyOpen;
        this.deleting = !deleting && blocked.getReason() == Blocked.Reason.DELETE ? true : deleting;
        this.blocked = deleting && blocked.getReason() != Blocked.Reason.DELETE ? new Blocked(Blocked.Reason.DELETE, null) : blocked;
        this.datafeedConfig = datafeedConfig;
    }

    public Job(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.jobType = in.readString();
        this.jobVersion = in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
        this.groups = in.getVersion().onOrAfter(Version.V_6_1_0) ? Collections.unmodifiableList(in.readStringList()) : Collections.emptyList();
        this.description = in.readOptionalString();
        this.createTime = new Date(in.readVLong());
        Date date = this.finishedTime = in.readBoolean() ? new Date(in.readVLong()) : null;
        if (in.getVersion().before(Version.V_7_0_0) && in.readBoolean()) {
            in.readVLong();
        }
        if (in.getVersion().onOrAfter(Version.V_6_1_0) && in.getVersion().before(Version.V_7_0_0)) {
            in.readOptionalLong();
        }
        this.analysisConfig = new AnalysisConfig(in);
        this.analysisLimits = (AnalysisLimits)in.readOptionalWriteable(AnalysisLimits::new);
        this.dataDescription = (DataDescription)in.readOptionalWriteable(DataDescription::new);
        this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
        this.renormalizationWindowDays = in.readOptionalLong();
        this.backgroundPersistInterval = in.readOptionalTimeValue();
        this.modelSnapshotRetentionDays = in.readOptionalLong();
        this.dailyModelSnapshotRetentionAfterDays = in.getVersion().onOrAfter(Version.V_7_8_0) ? in.readOptionalLong() : null;
        this.resultsRetentionDays = in.readOptionalLong();
        Map readCustomSettings = in.readMap();
        this.customSettings = readCustomSettings == null ? null : Collections.unmodifiableMap(readCustomSettings);
        this.modelSnapshotId = in.readOptionalString();
        this.modelSnapshotMinVersion = in.getVersion().onOrAfter(Version.V_7_0_0) && in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
        this.resultsIndexName = in.readString();
        this.deleting = in.readBoolean();
        this.allowLazyOpen = in.getVersion().onOrAfter(Version.V_7_5_0) ? in.readBoolean() : false;
        this.blocked = in.getVersion().onOrAfter(Version.V_7_14_0) ? new Blocked(in) : (this.deleting ? new Blocked(Blocked.Reason.DELETE, null) : Blocked.none());
        this.datafeedConfig = in.getVersion().onOrAfter(Version.V_7_15_0) ? (DatafeedConfig)in.readOptionalWriteable(DatafeedConfig::new) : null;
    }

    public static String documentId(String jobId) {
        if (!MlStrings.isValidId(jobId)) {
            throw new IllegalArgumentException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName(), jobId));
        }
        if (!MlStrings.hasValidLengthForId(jobId)) {
            throw new IllegalArgumentException(Messages.getMessage("The job id cannot contain more than {0,number,integer} characters.", 64));
        }
        return "anomaly_detector-" + jobId;
    }

    @Nullable
    public static String extractJobIdFromDocumentId(String docId) {
        String jobId = docId.replaceAll("^anomaly_detector-", "");
        return jobId.equals(docId) ? null : jobId;
    }

    public String getId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public Version getJobVersion() {
        return this.jobVersion;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getInitialResultsIndexName() {
        return ".ml-anomalies-" + this.resultsIndexName;
    }

    private String getResultsIndexNameNoPrefix() {
        return this.resultsIndexName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public AnalysisConfig getAnalysisConfig() {
        return this.analysisConfig;
    }

    public AnalysisLimits getAnalysisLimits() {
        return this.analysisLimits;
    }

    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    public DataDescription getDataDescription() {
        return this.dataDescription;
    }

    public Long getRenormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public TimeValue getBackgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public Long getModelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public Long getDailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    public Long getResultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    public String getModelSnapshotId() {
        return this.modelSnapshotId;
    }

    public Version getModelSnapshotMinVersion() {
        return this.modelSnapshotMinVersion;
    }

    public boolean isDeleting() {
        return this.deleting;
    }

    public boolean allowLazyOpen() {
        return this.allowLazyOpen;
    }

    public Blocked getBlocked() {
        return this.blocked;
    }

    public Collection<String> allInputFields() {
        String timeField;
        TreeSet<String> allFields = new TreeSet<String>();
        if (this.analysisConfig != null) {
            allFields.addAll(this.analysisConfig.analysisFields());
        }
        if (this.dataDescription != null && (timeField = this.dataDescription.getTimeField()) != null) {
            allFields.add(timeField);
        }
        allFields.remove("");
        allFields.remove("mlcategory");
        return allFields;
    }

    public long earliestValidTimestamp(DataCounts dataCounts) {
        long currentTime = 0L;
        Date latestRecordTimestamp = dataCounts.getLatestRecordTimeStamp();
        if (latestRecordTimestamp != null) {
            TimeValue latency = this.analysisConfig.getLatency();
            long latencyMillis = latency == null ? 0L : latency.millis();
            currentTime = latestRecordTimestamp.getTime() - latencyMillis;
        }
        return currentTime;
    }

    public Optional<DatafeedConfig> getDatafeedConfig() {
        return Optional.ofNullable(this.datafeedConfig);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeString(this.jobType);
        if (this.jobVersion != null) {
            out.writeBoolean(true);
            Version.writeVersion((Version)this.jobVersion, (StreamOutput)out);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeStringCollection(this.groups);
        }
        out.writeOptionalString(this.description);
        out.writeVLong(this.createTime.getTime());
        if (this.finishedTime != null) {
            out.writeBoolean(true);
            out.writeVLong(this.finishedTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0) && out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalLong(null);
        }
        this.analysisConfig.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.analysisLimits);
        out.writeOptionalWriteable((Writeable)this.dataDescription);
        out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
        out.writeOptionalLong(this.renormalizationWindowDays);
        out.writeOptionalTimeValue(this.backgroundPersistInterval);
        out.writeOptionalLong(this.modelSnapshotRetentionDays);
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeOptionalLong(this.dailyModelSnapshotRetentionAfterDays);
        }
        out.writeOptionalLong(this.resultsRetentionDays);
        out.writeMap(this.customSettings);
        out.writeOptionalString(this.modelSnapshotId);
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            if (this.modelSnapshotMinVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion((Version)this.modelSnapshotMinVersion, (StreamOutput)out);
            } else {
                out.writeBoolean(false);
            }
        }
        out.writeString(this.resultsIndexName);
        out.writeBoolean(this.deleting);
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeBoolean(this.allowLazyOpen);
        }
        if (out.getVersion().onOrAfter(Version.V_7_14_0)) {
            this.blocked.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
            out.writeOptionalWriteable((Writeable)this.datafeedConfig);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String humanReadableSuffix = "_string";
        builder.field(ID.getPreferredName(), this.jobId);
        if (!params.paramAsBoolean("exclude_generated", false)) {
            builder.field(JOB_TYPE.getPreferredName(), this.jobType);
            if (this.jobVersion != null) {
                builder.field(JOB_VERSION.getPreferredName(), (ToXContent)this.jobVersion);
            }
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.getTime());
            if (this.finishedTime != null) {
                builder.timeField(FINISHED_TIME.getPreferredName(), FINISHED_TIME.getPreferredName() + "_string", this.finishedTime.getTime());
            }
            if (this.modelSnapshotId != null) {
                builder.field(MODEL_SNAPSHOT_ID.getPreferredName(), this.modelSnapshotId);
            }
            if (this.deleting) {
                builder.field(DELETING.getPreferredName(), this.deleting);
            }
            if (this.modelSnapshotMinVersion != null) {
                builder.field(MODEL_SNAPSHOT_MIN_VERSION.getPreferredName(), (ToXContent)this.modelSnapshotMinVersion);
            }
            if (this.customSettings != null) {
                builder.field(CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
            }
            if (!params.paramAsBoolean("for_internal_storage", false) && this.datafeedConfig != null) {
                builder.field(DATAFEED_CONFIG.getPreferredName(), (ToXContent)this.datafeedConfig, params);
            }
        } else if (this.customSettings != null) {
            HashMap<String, Object> newCustomSettings = new HashMap<String, Object>(this.customSettings);
            newCustomSettings.remove("created_by");
            builder.field(CUSTOM_SETTINGS.getPreferredName(), newCustomSettings);
        }
        if (!this.groups.isEmpty()) {
            builder.field(GROUPS.getPreferredName(), this.groups);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.field(ANALYSIS_CONFIG.getPreferredName(), (ToXContent)this.analysisConfig, params);
        if (this.analysisLimits != null) {
            builder.field(ANALYSIS_LIMITS.getPreferredName(), (ToXContent)this.analysisLimits, params);
        }
        if (this.dataDescription != null) {
            builder.field(DATA_DESCRIPTION.getPreferredName(), (ToXContent)this.dataDescription, params);
        }
        if (this.modelPlotConfig != null) {
            builder.field(MODEL_PLOT_CONFIG.getPreferredName(), (ToXContent)this.modelPlotConfig, params);
        }
        if (this.renormalizationWindowDays != null) {
            builder.field(RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.field(BACKGROUND_PERSIST_INTERVAL.getPreferredName(), this.backgroundPersistInterval.getStringRep());
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.field(MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            builder.field(DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName(), this.dailyModelSnapshotRetentionAfterDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.field(RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
        }
        builder.field(RESULTS_INDEX_NAME.getPreferredName(), this.resultsIndexName);
        builder.field(ALLOW_LAZY_OPEN.getPreferredName(), this.allowLazyOpen);
        if (this.blocked.getReason() != Blocked.Reason.NONE) {
            builder.field(BLOCKED.getPreferredName(), (ToXContent)this.blocked);
        }
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Job)) {
            return false;
        }
        Job that = (Job)((Object)other);
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.jobVersion, that.jobVersion) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.finishedTime, that.finishedTime) && Objects.equals(this.analysisConfig, that.analysisConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.dataDescription, that.dataDescription) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.dailyModelSnapshotRetentionAfterDays, that.dailyModelSnapshotRetentionAfterDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId) && Objects.equals(this.modelSnapshotMinVersion, that.modelSnapshotMinVersion) && Objects.equals(this.resultsIndexName, that.resultsIndexName) && Objects.equals(this.deleting, that.deleting) && Objects.equals(this.allowLazyOpen, that.allowLazyOpen) && Objects.equals(this.blocked, that.blocked) && Objects.equals((Object)this.datafeedConfig, (Object)that.datafeedConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.jobType, this.jobVersion, this.groups, this.description, this.createTime, this.finishedTime, this.analysisConfig, this.analysisLimits, this.dataDescription, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.modelSnapshotMinVersion, this.resultsIndexName, this.deleting, this.allowLazyOpen, this.blocked, this.datafeedConfig});
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }

    private static void checkValueNotLessThan(long minVal, String name, Long value) {
        if (value != null && value < minVal) {
            throw new IllegalArgumentException(Messages.getMessage("{0} cannot be less than {1,number}. Value = {2,number}", name, minVal, value));
        }
    }

    public static Set<String> getCompatibleJobTypes(Version nodeVersion) {
        HashSet<String> compatibleTypes = new HashSet<String>();
        compatibleTypes.add(ANOMALY_DETECTOR_JOB_TYPE);
        return compatibleTypes;
    }

    public static class Builder
    implements Writeable {
        private String id;
        private String jobType = "anomaly_detector";
        private Version jobVersion;
        private List<String> groups = Collections.emptyList();
        private String description;
        private AnalysisConfig analysisConfig;
        private AnalysisLimits analysisLimits;
        private DataDescription dataDescription;
        private Date createTime;
        private Date finishedTime;
        private ModelPlotConfig modelPlotConfig;
        private Long renormalizationWindowDays;
        private TimeValue backgroundPersistInterval;
        private Long modelSnapshotRetentionDays = 10L;
        private Long dailyModelSnapshotRetentionAfterDays;
        private Long resultsRetentionDays;
        private Map<String, Object> customSettings;
        private String modelSnapshotId;
        private Version modelSnapshotMinVersion;
        private String resultsIndexName;
        private boolean deleting;
        private boolean allowLazyOpen;
        private Blocked blocked = Blocked.none();
        private DatafeedConfig.Builder datafeedConfig;

        public Builder() {
        }

        public Builder(String id) {
            this.id = id;
        }

        public Builder(Job job) {
            this.id = job.getId();
            this.jobType = job.getJobType();
            this.jobVersion = job.getJobVersion();
            this.groups = new ArrayList<String>(job.getGroups());
            this.description = job.getDescription();
            this.analysisConfig = job.getAnalysisConfig();
            this.analysisLimits = job.getAnalysisLimits();
            this.dataDescription = job.getDataDescription();
            this.createTime = job.getCreateTime();
            this.finishedTime = job.getFinishedTime();
            this.modelPlotConfig = job.getModelPlotConfig();
            this.renormalizationWindowDays = job.getRenormalizationWindowDays();
            this.backgroundPersistInterval = job.getBackgroundPersistInterval();
            this.modelSnapshotRetentionDays = job.getModelSnapshotRetentionDays();
            this.dailyModelSnapshotRetentionAfterDays = job.getDailyModelSnapshotRetentionAfterDays();
            this.resultsRetentionDays = job.getResultsRetentionDays();
            this.customSettings = job.getCustomSettings() == null ? null : new LinkedHashMap<String, Object>(job.getCustomSettings());
            this.modelSnapshotId = job.getModelSnapshotId();
            this.modelSnapshotMinVersion = job.getModelSnapshotMinVersion();
            this.resultsIndexName = job.getResultsIndexNameNoPrefix();
            this.deleting = job.isDeleting();
            this.allowLazyOpen = job.allowLazyOpen();
            this.blocked = job.getBlocked();
            this.datafeedConfig = job.getDatafeedConfig().isPresent() ? new DatafeedConfig.Builder(job.datafeedConfig) : null;
        }

        public Builder(StreamInput in) throws IOException {
            this.id = in.readOptionalString();
            this.jobType = in.readString();
            this.jobVersion = in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
            this.groups = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readStringList() : Collections.emptyList();
            this.description = in.readOptionalString();
            this.createTime = in.readBoolean() ? new Date(in.readVLong()) : null;
            Date date = this.finishedTime = in.readBoolean() ? new Date(in.readVLong()) : null;
            if (in.getVersion().before(Version.V_7_0_0) && in.readBoolean()) {
                in.readVLong();
            }
            if (in.getVersion().onOrAfter(Version.V_6_1_0) && in.getVersion().before(Version.V_7_0_0)) {
                in.readOptionalLong();
            }
            this.analysisConfig = (AnalysisConfig)in.readOptionalWriteable(AnalysisConfig::new);
            this.analysisLimits = (AnalysisLimits)in.readOptionalWriteable(AnalysisLimits::new);
            this.dataDescription = (DataDescription)in.readOptionalWriteable(DataDescription::new);
            this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
            this.renormalizationWindowDays = in.readOptionalLong();
            this.backgroundPersistInterval = in.readOptionalTimeValue();
            this.modelSnapshotRetentionDays = in.readOptionalLong();
            if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
                this.dailyModelSnapshotRetentionAfterDays = in.readOptionalLong();
            }
            this.resultsRetentionDays = in.readOptionalLong();
            this.customSettings = in.readMap();
            this.modelSnapshotId = in.readOptionalString();
            this.modelSnapshotMinVersion = in.getVersion().onOrAfter(Version.V_7_0_0) && in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
            this.resultsIndexName = in.readOptionalString();
            this.deleting = in.readBoolean();
            if (in.getVersion().onOrAfter(Version.V_7_5_0)) {
                this.allowLazyOpen = in.readBoolean();
            }
            this.blocked = in.getVersion().onOrAfter(Version.V_7_14_0) ? new Blocked(in) : Blocked.none();
            if (in.getVersion().onOrAfter(Version.V_7_15_0)) {
                this.datafeedConfig = (DatafeedConfig.Builder)in.readOptionalWriteable(DatafeedConfig.Builder::new);
            }
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public void setJobVersion(Version jobVersion) {
            this.jobVersion = jobVersion;
        }

        private void setJobVersion(String jobVersion) {
            this.jobVersion = Version.fromString((String)jobVersion);
        }

        private void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public void setGroups(List<String> groups) {
            this.groups = groups == null ? Collections.emptyList() : groups;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public Builder setCustomSettings(Map<String, Object> customSettings) {
            this.customSettings = customSettings;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setAnalysisConfig(AnalysisConfig.Builder configBuilder) {
            this.analysisConfig = ExceptionsHelper.requireNonNull(configBuilder, ANALYSIS_CONFIG.getPreferredName()).build();
            return this;
        }

        public AnalysisConfig getAnalysisConfig() {
            return this.analysisConfig;
        }

        public Builder setAnalysisLimits(AnalysisLimits analysisLimits) {
            this.analysisLimits = ExceptionsHelper.requireNonNull(analysisLimits, ANALYSIS_LIMITS.getPreferredName());
            return this;
        }

        public Builder setCreateTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setFinishedTime(Date finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public Builder setDataDescription(DataDescription.Builder dataDescription) {
            this.dataDescription = ExceptionsHelper.requireNonNull(dataDescription, DATA_DESCRIPTION.getPreferredName()).build();
            return this;
        }

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setBackgroundPersistInterval(TimeValue backgroundPersistInterval) {
            this.backgroundPersistInterval = backgroundPersistInterval;
            return this;
        }

        public Builder setRenormalizationWindowDays(Long renormalizationWindowDays) {
            this.renormalizationWindowDays = renormalizationWindowDays;
            return this;
        }

        public Builder setModelSnapshotRetentionDays(Long modelSnapshotRetentionDays) {
            this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
            return this;
        }

        public Long getModelSnapshotRetentionDays() {
            return this.modelSnapshotRetentionDays;
        }

        public Builder setDailyModelSnapshotRetentionAfterDays(Long dailyModelSnapshotRetentionAfterDays) {
            this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
            return this;
        }

        public Builder setResultsRetentionDays(Long resultsRetentionDays) {
            this.resultsRetentionDays = resultsRetentionDays;
            return this;
        }

        public Builder setModelSnapshotId(String modelSnapshotId) {
            this.modelSnapshotId = modelSnapshotId;
            return this;
        }

        public Builder setModelSnapshotMinVersion(Version modelSnapshotMinVersion) {
            this.modelSnapshotMinVersion = modelSnapshotMinVersion;
            return this;
        }

        Builder setModelSnapshotMinVersion(String modelSnapshotMinVersion) {
            this.modelSnapshotMinVersion = Version.fromString((String)modelSnapshotMinVersion);
            return this;
        }

        public Builder setResultsIndexName(String resultsIndexName) {
            this.resultsIndexName = resultsIndexName;
            return this;
        }

        public Builder setDeleting(boolean deleting) {
            this.deleting = deleting;
            return this;
        }

        public Builder setAllowLazyOpen(boolean allowLazyOpen) {
            this.allowLazyOpen = allowLazyOpen;
            return this;
        }

        public Builder setBlocked(Blocked blocked) {
            this.blocked = ExceptionsHelper.requireNonNull(blocked, BLOCKED);
            return this;
        }

        public Builder setDatafeed(DatafeedConfig.Builder datafeed) {
            this.datafeedConfig = datafeed;
            return this;
        }

        public DatafeedConfig.Builder getDatafeedConfig() {
            return this.datafeedConfig;
        }

        public Builder setDatafeedIndicesOptionsIfRequired(IndicesOptions indicesOptions) {
            if (this.datafeedConfig != null && this.datafeedConfig.getIndicesOptions() == null) {
                this.datafeedConfig.setIndicesOptions(indicesOptions);
            }
            return this;
        }

        public List<String> invalidCreateTimeSettings() {
            ArrayList<String> invalidCreateValues = new ArrayList<String>();
            if (this.modelSnapshotId != null) {
                invalidCreateValues.add(MODEL_SNAPSHOT_ID.getPreferredName());
            }
            if (this.finishedTime != null) {
                invalidCreateValues.add(FINISHED_TIME.getPreferredName());
            }
            if (this.createTime != null) {
                invalidCreateValues.add(CREATE_TIME.getPreferredName());
            }
            return invalidCreateValues;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.id);
            out.writeString(this.jobType);
            if (this.jobVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion((Version)this.jobVersion, (StreamOutput)out);
            } else {
                out.writeBoolean(false);
            }
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeStringCollection(this.groups);
            }
            out.writeOptionalString(this.description);
            if (this.createTime != null) {
                out.writeBoolean(true);
                out.writeVLong(this.createTime.getTime());
            } else {
                out.writeBoolean(false);
            }
            if (this.finishedTime != null) {
                out.writeBoolean(true);
                out.writeVLong(this.finishedTime.getTime());
            } else {
                out.writeBoolean(false);
            }
            if (out.getVersion().before(Version.V_7_0_0)) {
                out.writeBoolean(false);
            }
            if (out.getVersion().onOrAfter(Version.V_6_1_0) && out.getVersion().before(Version.V_7_0_0)) {
                out.writeOptionalLong(null);
            }
            out.writeOptionalWriteable((Writeable)this.analysisConfig);
            out.writeOptionalWriteable((Writeable)this.analysisLimits);
            out.writeOptionalWriteable((Writeable)this.dataDescription);
            out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
            out.writeOptionalLong(this.renormalizationWindowDays);
            out.writeOptionalTimeValue(this.backgroundPersistInterval);
            out.writeOptionalLong(this.modelSnapshotRetentionDays);
            if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
                out.writeOptionalLong(this.dailyModelSnapshotRetentionAfterDays);
            }
            out.writeOptionalLong(this.resultsRetentionDays);
            out.writeMap(this.customSettings);
            out.writeOptionalString(this.modelSnapshotId);
            if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
                if (this.modelSnapshotMinVersion != null) {
                    out.writeBoolean(true);
                    Version.writeVersion((Version)this.modelSnapshotMinVersion, (StreamOutput)out);
                } else {
                    out.writeBoolean(false);
                }
            }
            out.writeOptionalString(this.resultsIndexName);
            out.writeBoolean(this.deleting);
            if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
                out.writeBoolean(this.allowLazyOpen);
            }
            if (out.getVersion().onOrAfter(Version.V_7_14_0)) {
                this.blocked.writeTo(out);
            }
            if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
                out.writeOptionalWriteable((Writeable)this.datafeedConfig);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.jobVersion, that.jobVersion) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.analysisConfig, that.analysisConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.dataDescription, that.dataDescription) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.finishedTime, that.finishedTime) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.dailyModelSnapshotRetentionAfterDays, that.dailyModelSnapshotRetentionAfterDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId) && Objects.equals(this.modelSnapshotMinVersion, that.modelSnapshotMinVersion) && Objects.equals(this.resultsIndexName, that.resultsIndexName) && Objects.equals(this.deleting, that.deleting) && Objects.equals(this.allowLazyOpen, that.allowLazyOpen) && Objects.equals(this.blocked, that.blocked) && Objects.equals(this.datafeedConfig, that.datafeedConfig);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.jobType, this.jobVersion, this.groups, this.description, this.analysisConfig, this.analysisLimits, this.dataDescription, this.createTime, this.finishedTime, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.modelSnapshotMinVersion, this.resultsIndexName, this.deleting, this.allowLazyOpen, this.blocked, this.datafeedConfig);
        }

        public void validateInputFields() {
            if (this.analysisConfig == null) {
                throw new IllegalArgumentException(Messages.getMessage("An analysis_config must be set"));
            }
            if (this.dataDescription == null) {
                throw new IllegalArgumentException(Messages.getMessage("A data_description must be set"));
            }
            Builder.checkTimeFieldNotInAnalysisConfig(this.dataDescription, this.analysisConfig);
            this.checkValidBackgroundPersistInterval();
            Job.checkValueNotLessThan(0L, RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
            Job.checkValueNotLessThan(0L, RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
            if (!MlStrings.isValidId(this.id)) {
                throw new IllegalArgumentException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName(), this.id));
            }
            if (!MlStrings.hasValidLengthForId(this.id)) {
                throw new IllegalArgumentException(Messages.getMessage("The job id cannot contain more than {0,number,integer} characters.", 64));
            }
            this.validateModelSnapshotRetentionSettings();
            this.validateGroups();
            if (!Strings.isNullOrEmpty((String)this.resultsIndexName) && !MlStrings.isValidId(this.resultsIndexName)) {
                throw new IllegalArgumentException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", RESULTS_INDEX_NAME.getPreferredName(), this.resultsIndexName));
            }
        }

        public void validateAnalysisLimitsAndSetDefaults(@Nullable ByteSizeValue maxModelMemoryLimit) {
            this.analysisLimits = AnalysisLimits.validateAndSetDefaults(this.analysisLimits, maxModelMemoryLimit, 1024L);
        }

        public void validateModelSnapshotRetentionSettingsAndSetDefaults() {
            this.validateModelSnapshotRetentionSettings();
            if (this.dailyModelSnapshotRetentionAfterDays == null && this.modelSnapshotRetentionDays != null && this.modelSnapshotRetentionDays > 1L) {
                this.dailyModelSnapshotRetentionAfterDays = 1L;
            }
        }

        public void validateModelSnapshotRetentionSettings() {
            Job.checkValueNotLessThan(0L, MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
            Job.checkValueNotLessThan(0L, DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName(), this.dailyModelSnapshotRetentionAfterDays);
            if (this.modelSnapshotRetentionDays != null && this.dailyModelSnapshotRetentionAfterDays != null && this.dailyModelSnapshotRetentionAfterDays > this.modelSnapshotRetentionDays) {
                throw new IllegalArgumentException(Messages.getMessage(Messages.JOB_CONFIG_MODEL_SNAPSHOT_RETENTION_SETTINGS_INCONSISTENT, this.dailyModelSnapshotRetentionAfterDays, this.modelSnapshotRetentionDays));
            }
        }

        private void validateGroups() {
            for (String group : this.groups) {
                if (!MlStrings.isValidId(group)) {
                    throw new IllegalArgumentException(Messages.getMessage("Invalid group id ''{0}''; must be non-empty string and may contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", group));
                }
                if (!this.id.equals(group)) continue;
                throw new ResourceAlreadyExistsException(Messages.getMessage("job and group names must be unique but job [{0}] and group [{0}] have the same name", group), new Object[0]);
            }
        }

        public void validateDetectorsAreUnique() {
            HashSet<Detector> canonicalDetectors = new HashSet<Detector>();
            for (Detector detector : this.analysisConfig.getDetectors()) {
                Detector canonicalDetector = new Detector.Builder(detector).setDetectorIndex(0).build();
                if (canonicalDetectors.add(canonicalDetector)) continue;
                throw new IllegalArgumentException(Messages.getMessage("Duplicate detectors are not allowed: [{0}]", detector.getDetectorDescription()));
            }
        }

        public Job build(Date createTime) {
            this.setCreateTime(createTime);
            this.setJobVersion(Version.CURRENT);
            return this.build();
        }

        public Job build() {
            this.analysisLimits = AnalysisLimits.validateAndSetDefaults(this.analysisLimits, null, 4096L);
            this.validateInputFields();
            ExceptionsHelper.requireNonNull(this.createTime, CREATE_TIME.getPreferredName());
            if (Strings.isNullOrEmpty((String)this.resultsIndexName)) {
                this.resultsIndexName = "shared";
            } else if (!this.resultsIndexName.equals("shared")) {
                String string = this.resultsIndexName = this.resultsIndexName.startsWith("custom-") ? this.resultsIndexName : "custom-" + this.resultsIndexName;
            }
            if (this.datafeedConfig != null) {
                if (this.datafeedConfig.getId() == null) {
                    this.datafeedConfig.setId(this.id);
                }
                if (this.datafeedConfig.getJobId() != null && !this.datafeedConfig.getJobId().equals(this.id)) {
                    throw new IllegalArgumentException(Messages.getMessage("datafeed job_id [{0}] does not equal job id [{1}}", this.datafeedConfig.getJobId(), this.id));
                }
                this.datafeedConfig.setJobId(this.id);
            }
            return new Job(this.id, this.jobType, this.jobVersion, this.groups, this.description, this.createTime, this.finishedTime, this.analysisConfig, this.analysisLimits, this.dataDescription, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.modelSnapshotMinVersion, this.resultsIndexName, this.deleting, this.allowLazyOpen, this.blocked, Optional.ofNullable(this.datafeedConfig).map(DatafeedConfig.Builder::build).orElse(null));
        }

        private void checkValidBackgroundPersistInterval() {
            if (this.backgroundPersistInterval != null) {
                TimeUtils.checkMultiple(this.backgroundPersistInterval, TimeUnit.SECONDS, BACKGROUND_PERSIST_INTERVAL);
                Job.checkValueNotLessThan(MIN_BACKGROUND_PERSIST_INTERVAL.getSeconds(), BACKGROUND_PERSIST_INTERVAL.getPreferredName(), this.backgroundPersistInterval.getSeconds());
            }
        }

        static void checkTimeFieldNotInAnalysisConfig(DataDescription dataDescription, AnalysisConfig analysisConfig) {
            if (analysisConfig.analysisFields().contains(dataDescription.getTimeField())) {
                throw new IllegalArgumentException(Messages.getMessage("data_description.time_field may not be used in the analysis_config"));
            }
        }
    }
}

