/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentLocation;

public class LoggingDeprecationAccumulationHandler
implements DeprecationHandler {
    private final List<String> deprecations = new ArrayList<String>();

    public void usedDeprecatedName(String parserName, Supplier<XContentLocation> location, String usedName, String modernName) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(parserName, location, usedName, modernName);
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        this.deprecations.add(LoggerMessageFormat.format((String)"{}Deprecated field [{}] used, expected [{}] instead", (Object[])new Object[]{prefix, usedName, modernName}));
    }

    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName, String replacedWith) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedField(parserName, location, usedName, replacedWith);
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        this.deprecations.add(LoggerMessageFormat.format((String)"{}Deprecated field [{}] used, replaced by [{}]", (Object[])new Object[]{prefix, usedName, replacedWith}));
    }

    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedField(parserName, location, usedName);
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        this.deprecations.add(LoggerMessageFormat.format((String)"{}Deprecated field [{}] used, unused and will be removed entirely", (Object[])new Object[]{prefix, usedName}));
    }

    public List<String> getDeprecations() {
        return Collections.unmodifiableList(this.deprecations);
    }
}

