/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url.http;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public class URLHttpClientSettings {
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final int DEFAULT_CONNECTION_POOL_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(10L);
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(10L);
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(50L);
    static final Setting<TimeValue> SOCKET_TIMEOUT_SETTING = Setting.timeSetting((String)"http_socket_timeout", (TimeValue)TimeValue.timeValueMillis((long)DEFAULT_SOCKET_TIMEOUT_MILLIS), (TimeValue)TimeValue.timeValueMillis((long)1L), (TimeValue)TimeValue.timeValueMinutes((long)60L), (Setting.Property[])new Setting.Property[0]);
    static final Setting<Integer> HTTP_MAX_RETRIES_SETTING = Setting.intSetting((String)"http_max_retries", (int)5, (int)0, (int)Integer.MAX_VALUE, (Setting.Property[])new Setting.Property[0]);
    private int maxRetries = 5;
    private int connectionPoolTimeoutMs = DEFAULT_CONNECTION_POOL_TIMEOUT_MILLIS;
    private int connectionTimeoutMs = DEFAULT_CONNECTION_TIMEOUT_MILLIS;
    private int socketTimeoutMs = DEFAULT_SOCKET_TIMEOUT_MILLIS;

    public static URLHttpClientSettings fromSettings(Settings settings) {
        URLHttpClientSettings httpClientSettings = new URLHttpClientSettings();
        httpClientSettings.setSocketTimeoutMs((int)((TimeValue)SOCKET_TIMEOUT_SETTING.get(settings)).millis());
        httpClientSettings.setMaxRetries((Integer)HTTP_MAX_RETRIES_SETTING.get(settings));
        return httpClientSettings;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setConnectionPoolTimeoutMs(int connectionPoolTimeoutMs) {
        this.connectionPoolTimeoutMs = connectionPoolTimeoutMs;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getConnectionPoolTimeoutMs() {
        return this.connectionPoolTimeoutMs;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }
}

