/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.monitoring.MonitoringFeatureSetUsage;
import org.elasticsearch.xpack.monitoring.MonitoringService;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;

public class MonitoringFeatureSet
implements XPackFeatureSet {
    private final MonitoringService monitoring;
    private final Exporters exporters;

    @Inject
    public MonitoringFeatureSet(@Nullable MonitoringService monitoring, @Nullable Exporters exporters) {
        this.monitoring = monitoring;
        this.exporters = exporters;
    }

    public String name() {
        return "monitoring";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        boolean collectionEnabled = this.monitoring != null && this.monitoring.isMonitoringActive();
        listener.onResponse((Object)new MonitoringFeatureSetUsage(collectionEnabled, MonitoringFeatureSet.exportersUsage(this.exporters)));
    }

    static Map<String, Object> exportersUsage(Exporters exporters) {
        if (exporters == null) {
            return null;
        }
        HashMap<String, Object> usage = new HashMap<String, Object>();
        for (Exporter exporter : exporters.getEnabledExporters()) {
            if (!exporter.config().enabled()) continue;
            String type = exporter.config().type();
            int count = (Integer)usage.getOrDefault(type, 0);
            usage.put(type, count + 1);
        }
        return usage;
    }
}

