/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;

public class FixedAutoscalingDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "fixed";
    public static final Setting<ByteSizeValue> STORAGE = Setting.byteSizeSetting((String)"storage", (ByteSizeValue)ByteSizeValue.ofBytes((long)-1L), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<ByteSizeValue> MEMORY = Setting.byteSizeSetting((String)"memory", (ByteSizeValue)ByteSizeValue.ofBytes((long)-1L), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> NODES = Setting.intSetting((String)"nodes", (int)1, (int)0, (Setting.Property[])new Setting.Property[0]);

    @Inject
    public FixedAutoscalingDeciderService() {
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        int nodes = (Integer)NODES.get(configuration);
        ByteSizeValue storage = STORAGE.exists(configuration) ? (ByteSizeValue)STORAGE.get(configuration) : null;
        ByteSizeValue memory = MEMORY.exists(configuration) ? (ByteSizeValue)MEMORY.get(configuration) : null;
        AutoscalingCapacity requiredCapacity = storage != null || memory != null ? AutoscalingCapacity.builder().total(FixedAutoscalingDeciderService.totalCapacity(storage, nodes), FixedAutoscalingDeciderService.totalCapacity(memory, nodes)).node(storage, memory).build() : null;
        return new AutoscalingDeciderResult(requiredCapacity, new FixedReason(storage, memory, nodes));
    }

    private static ByteSizeValue totalCapacity(ByteSizeValue nodeCapacity, int nodes) {
        if (nodeCapacity != null) {
            return new ByteSizeValue(nodeCapacity.getBytes() * (long)nodes);
        }
        return null;
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return org.elasticsearch.core.List.of((Object[])new Setting[]{STORAGE, MEMORY, NODES});
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return Collections.unmodifiableList(new ArrayList(DiscoveryNode.getPossibleRoles()));
    }

    @Override
    public boolean appliesToEmptyRoles() {
        return true;
    }

    @Override
    public boolean defaultOn() {
        return false;
    }

    public static class FixedReason
    implements AutoscalingDeciderResult.Reason {
        private final ByteSizeValue storage;
        private final ByteSizeValue memory;
        private final int nodes;

        public FixedReason(ByteSizeValue storage, ByteSizeValue memory, int nodes) {
            this.storage = storage;
            this.memory = memory;
            this.nodes = nodes;
        }

        public FixedReason(StreamInput in) throws IOException {
            this.storage = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.memory = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.nodes = in.readInt();
        }

        @Override
        public String summary() {
            return "fixed storage [" + this.storage + "] memory [" + this.memory + "] nodes [" + this.nodes + "]";
        }

        public String getWriteableName() {
            return FixedAutoscalingDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.storage);
            out.writeOptionalWriteable((Writeable)this.memory);
            out.writeInt(this.nodes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("storage", (ToXContent)this.storage);
            builder.field("memory", (ToXContent)this.memory);
            builder.field("nodes", this.nodes);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedReason that = (FixedReason)o;
            return this.nodes == that.nodes && Objects.equals(this.storage, that.storage) && Objects.equals(this.memory, that.memory);
        }

        public int hashCode() {
            return Objects.hash(this.storage, this.memory, this.nodes);
        }
    }
}

