/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.tasks.TaskCancelledException;

class CapacityResponseCache<Response> {
    private final Queue<Job> jobQueue = ConcurrentCollections.newQueue();
    private final AtomicInteger jobQueueSize = new AtomicInteger();
    private final Function<Runnable, Response> refresher;
    private final Consumer<Runnable> runOnThread;

    CapacityResponseCache(Consumer<Runnable> runOnThread, Function<Runnable, Response> refresher) {
        this.runOnThread = runOnThread;
        this.refresher = refresher;
    }

    public void get(BooleanSupplier isCancelled, ActionListener<Response> listener) {
        this.jobQueue.offer(new Job(isCancelled, listener));
        assert (this.jobQueueSize.get() >= 0);
        if (this.jobQueueSize.getAndIncrement() == 0) {
            try {
                this.runOnThread.accept(this::singleThreadRefresh);
            }
            catch (Exception e) {
                do {
                    Job jobToFail = this.jobQueue.poll();
                    assert (jobToFail != null);
                    jobToFail.onFailure(e);
                } while (this.jobQueueSize.decrementAndGet() > 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void singleThreadRefresh() {
        assert (this.jobQueueSize.get() > 0) : "poor man's single thread check";
        int jobCount = this.jobQueueSize.get();
        do {
            try {
                ListenableFuture future = new ListenableFuture();
                ArrayList<Job> jobs = new ArrayList<Job>(jobCount);
                for (int i = 0; i < jobCount; ++i) {
                    Job job = this.jobQueue.remove();
                    assert (job != null) : this.jobQueueSize.get() + " queue size is out of sync";
                    jobs.add(job);
                    future.addListener(job.listener);
                }
                Runnable ensureNotCancelled = () -> {
                    for (Job job : jobs) {
                        if (job.isCancelled()) continue;
                        return;
                    }
                    throw new TaskCancelledException("task cancelled");
                };
                ActionListener.completeWith((ActionListener)future, () -> this.refresher.apply(ensureNotCancelled));
            }
            finally {
                jobCount = this.jobQueueSize.addAndGet(-jobCount);
            }
        } while (jobCount > 0);
    }

    int jobQueueSize() {
        return this.jobQueueSize.get();
    }

    int jobQueueCount() {
        return this.jobQueue.size();
    }

    private class Job {
        private final BooleanSupplier isCancelled;
        private final ActionListener<Response> listener;

        private Job(BooleanSupplier isCancelled, ActionListener<Response> listener) {
            this.isCancelled = isCancelled;
            this.listener = listener;
        }

        public boolean isCancelled() {
            return this.isCancelled.getAsBoolean();
        }

        public void onFailure(Exception e) {
            block2: {
                try {
                    this.listener.onFailure(e);
                }
                catch (Exception e2) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }
    }
}

