/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authz.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class ValidateRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor {
    private final boolean enabled;

    public ValidateRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState, Settings settings) {
        super(threadPool.getThreadContext(), licenseState);
        this.enabled = (Boolean)Security.DLS_ERROR_WHEN_VALIDATE_QUERY_WITH_REWRITE.get(settings);
    }

    @Override
    void disableFeatures(IndicesRequest indicesRequest, Map<String, IndicesAccessControl.IndexAccessControl> indexAccessControlByIndex, ActionListener<Void> listener) {
        ValidateQueryRequest request = (ValidateQueryRequest)indicesRequest;
        if (indexAccessControlByIndex.values().stream().anyMatch(iac -> iac.getDocumentPermissions().hasDocumentLevelPermissions())) {
            if (ValidateRequestInterceptor.hasRewrite(request)) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Validate with rewrite isn't supported if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
            } else {
                listener.onResponse(null);
            }
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean supports(IndicesRequest request) {
        if (this.enabled && request instanceof ValidateQueryRequest) {
            ValidateQueryRequest validateQueryRequest = (ValidateQueryRequest)request;
            return ValidateRequestInterceptor.hasRewrite(validateQueryRequest);
        }
        return false;
    }

    private static boolean hasRewrite(ValidateQueryRequest validateQueryRequest) {
        return validateQueryRequest.rewrite();
    }
}

