/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalMin;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public class HistoBackedMinAggregator
extends NumericMetricsAggregator.SingleValue {
    private final HistogramValuesSource.Histogram valuesSource;
    final DocValueFormat format;
    DoubleArray mins;

    public HistoBackedMinAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        HistogramValuesSource.Histogram histogram = this.valuesSource = config.hasValues() ? (HistogramValuesSource.Histogram)config.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.mins = this.bigArrays().newDoubleArray(1L, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        }
        this.format = config.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final HistogramValues values = this.valuesSource.getHistogramValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= HistoBackedMinAggregator.this.mins.size()) {
                    long from = HistoBackedMinAggregator.this.mins.size();
                    HistoBackedMinAggregator.this.mins = HistoBackedMinAggregator.this.bigArrays().grow(HistoBackedMinAggregator.this.mins, bucket + 1L);
                    HistoBackedMinAggregator.this.mins.fill(from, HistoBackedMinAggregator.this.mins.size(), Double.POSITIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    while (sketch.next()) {
                        double value = sketch.value();
                        double min = HistoBackedMinAggregator.this.mins.get(bucket);
                        min = Math.min(min, value);
                        HistoBackedMinAggregator.this.mins.set(bucket, min);
                    }
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.mins.size()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mins.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.mins.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMin(this.name, this.mins.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMin(this.name, Double.POSITIVE_INFINITY, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.mins);
    }
}

