/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.java_version_checker;

import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.tools.java_version_checker.JavaVersion;
import org.elasticsearch.tools.java_version_checker.SuppressForbidden;

final class JavaVersionChecker {
    private JavaVersionChecker() {
    }

    public static void main(String[] args) {
        String message;
        if (args.length != 0) {
            throw new IllegalArgumentException("expected zero arguments but was " + Arrays.toString(args));
        }
        if (JavaVersion.compare(JavaVersion.CURRENT, JavaVersion.JAVA_8) < 0) {
            message = String.format(Locale.ROOT, "The minimum required Java version is 8; your Java version from [%s] does not meet this requirement. Consider switching to a distribution of Elasticsearch with a bundled JDK. If you are already using a distribution with a bundled JDK, ensure the JAVA_HOME environment variable is not set.", System.getProperty("java.home"));
            JavaVersionChecker.errPrintln(message);
            JavaVersionChecker.exit(1);
        }
        if (JavaVersion.compare(JavaVersion.CURRENT, JavaVersion.JAVA_11) < 0) {
            message = String.format(Locale.ROOT, "Future versions of Elasticsearch will require Java 11; your Java version from [%s] does not meet this requirement. Consider switching to a distribution of Elasticsearch with a bundled JDK. If you are already using a distribution with a bundled JDK, ensure the JAVA_HOME environment variable is not set.", System.getProperty("java.home"));
            JavaVersionChecker.errPrintln(message);
        }
        JavaVersionChecker.exit(0);
    }

    @SuppressForbidden(reason="System#err")
    static void errPrintln(String message) {
        System.err.println(message);
    }

    @SuppressForbidden(reason="System#exit")
    static void exit(int status) {
        System.exit(status);
    }
}

