<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/vcsa/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/vcsa/metadata.yaml"
sidebar_label: "vCenter Server Appliance"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Containers and VMs"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# vCenter Server Appliance


<img src="https://netdata.cloud/img/vmware.svg" width="150"/>


Plugin: go.d.plugin
Module: vcsa

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors [health statistics](https://developer.vmware.com/apis/vsphere-automation/latest/appliance/health/) of vCenter Server Appliance servers.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per vCenter Server Appliance instance

These metrics refer to the entire monitored application.
<details>
<summary>See health statuses</summary>
Overall System Health:

| Status  | Description                                                                                                              |
|:-------:|:-------------------------------------------------------------------------------------------------------------------------|
|  green  | All components in the appliance are healthy.                                                                             |
| yellow  | One or more components in the appliance might become overloaded soon.                                                    |
| orange  | One or more components in the appliance might be degraded.                                                               |
|   red   | One or more components in the appliance might be in an unusable status and the appliance might become unresponsive soon. |
|  gray   | No health data is available.                                                                                             |
| unknown | Collector failed to decode status.                                                                                       |

Components Health:

| Status  | Description                                                  |
|:-------:|:-------------------------------------------------------------|
|  green  | The component is healthy.                                    |
| yellow  | The component is healthy, but may have some problems.        |
| orange  | The component is degraded, and may have serious problems.    |
|   red   | The component is unavailable, or will stop functioning soon. |
|  gray   | No health data is available.                                 |
| unknown | Collector failed to decode status.                           |

Software Updates Health:

| Status  | Description                                          |
|:-------:|:-----------------------------------------------------|
|  green  | No updates available.                                |
| orange  | Non-security patches might be available.             |
|   red   | Security patches might be available.                 |
|  gray   | An error retrieving information on software updates. |
| unknown | Collector failed to decode status.                   |

</details>


This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| vcsa.system_health_status | green, red, yellow, orange, gray, unknown | status |
| vcsa.applmgmt_health_status | green, red, yellow, orange, gray, unknown | status |
| vcsa.load_health_status | green, red, yellow, orange, gray, unknown | status |
| vcsa.mem_health_status | green, red, yellow, orange, gray, unknown | status |
| vcsa.swap_health_status | green, red, yellow, orange, gray, unknown | status |
| vcsa.database_storage_health_status | green, red, yellow, orange, gray, unknown | status |
| vcsa.storage_health_status | green, red, yellow, orange, gray, unknown | status |
| vcsa.software_packages_health_status | green, red, orange, gray, unknown | status |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ vcsa_system_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.system_health_status | VCSA overall system status is orange. One or more components are degraded. |
| [ vcsa_system_health_crit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.system_health_status | VCSA overall system status is red. One or more components are unavailable or will stop functioning soon. |
| [ vcsa_applmgmt_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.applmgmt_health_status | VCSA ApplMgmt component status is orange. It is degraded, and may have serious problems. |
| [ vcsa_applmgmt_health_crit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.applmgmt_health_status | VCSA ApplMgmt component status is red. It is unavailable, or will stop functioning soon. |
| [ vcsa_load_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.load_health_status | VCSA Load component status is orange. It is degraded, and may have serious problems. |
| [ vcsa_load_health_crit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.load_health_status | VCSA Load component status is red. It is unavailable, or will stop functioning soon. |
| [ vcsa_mem_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.mem_health_status | VCSA Memory component status is orange. It is degraded, and may have serious problems. |
| [ vcsa_mem_health_crit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.mem_health_status | VCSA Memory component status is red. It is unavailable, or will stop functioning soon. |
| [ vcsa_swap_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.swap_health_status | VCSA Swap component status is orange. It is degraded, and may have serious problems. |
| [ vcsa_swap_health_crit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.swap_health_status | VCSA Swap component status is red. It is unavailable, or will stop functioning soon. |
| [ vcsa_database_storage_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.database_storage_health_status | VCSA Database Storage component status is orange. It is degraded, and may have serious problems. |
| [ vcsa_database_storage_health_crit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.database_storage_health_status | VCSA Database Storage component status is red. It is unavailable, or will stop functioning soon. |
| [ vcsa_storage_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.storage_health_status | VCSA Storage component status is orange. It is degraded, and may have serious problems. |
| [ vcsa_storage_health_crit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.storage_health_status | VCSA Storage component status is red. It is unavailable, or will stop functioning soon. |
| [ vcsa_software_packages_health_warn ](https://github.com/netdata/netdata/blob/master/src/health/health.d/vcsa.conf) | vcsa.software_packages_health_status | VCSA software packages security updates are available. |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/vcsa.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/vcsa.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. |  | yes |
| timeout | HTTP request timeout. | 1 | no |
| username | Username for basic HTTP authentication. |  | yes |
| password | Password for basic HTTP authentication. |  | yes |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | false | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | false | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: vcsa1
    url: https://203.0.113.1
    username: admin@vsphere.local
    password: password

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Two instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: vcsa1
    url: https://203.0.113.1
    username: admin@vsphere.local
    password: password

  - name: vcsa2
    url: https://203.0.113.10
    username: admin@vsphere.local
    password: password

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `vcsa` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m vcsa
  ```


