<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/smartctl/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/smartctl/metadata.yaml"
sidebar_label: "S.M.A.R.T."
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Hardware Devices and Sensors"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# S.M.A.R.T.


<img src="https://netdata.cloud/img/smart.png" width="150"/>


Plugin: go.d.plugin
Module: smartctl

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors the health status of storage devices by analyzing S.M.A.R.T. (Self-Monitoring, Analysis, and Reporting Technology) counters.
It relies on the [`smartctl`](https://linux.die.net/man/8/smartctl) CLI tool but avoids directly executing the binary.
Instead, it utilizes `ndsudo`, a Netdata helper specifically designed to run privileged commands securely within the Netdata environment.
This approach eliminates the need to use `sudo`, improving security and potentially simplifying permission management.

Executed commands:
-  `smartctl --json --scan`
-  `smartctl --json --all {deviceName} --device {deviceType} --nocheck {powerMode}`




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per controller

These metrics refer to the Storage Device.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| device_name | Device name |
| device_type | Device type |
| model_name | Model name |
| serial_number | Serial number |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| smartctl.device_smart_status | passed, failed | status |
| smartctl.device_ata_smart_error_log_count | error_log | logs |
| smartctl.device_power_on_time | power_on_time | seconds |
| smartctl.device_temperature | temperature | Celsius |
| smartctl.device_power_cycles_count | power | cycles |
| smartctl.device_smart_attr_{attribute_name} | {attribute_name} | {attribute_unit} |
| smartctl.device_smart_attr_{attribute_name}_normalized | {attribute_name} | value |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install smartmontools (v7.0+)

Install `smartmontools` version 7.0 or later using your distribution's package manager. Version 7.0 introduced the `--json` output mode, which is required for this collector to function properly.



### Configuration

#### File

The configuration file name for this integration is `go.d/smartctl.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/smartctl.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | interval for updating Netdata charts, measured in seconds. Collector might use cached data if less than **Devices poll interval**. | 10 | no |
| timeout | smartctl binary execution timeout. | 5 | no |
| scan_every | interval for discovering new devices using `smartctl --scan`, measured in seconds. | 900 | no |
| poll_devices_every | interval for gathering data for every device, measured in seconds. Data is cached for this interval. | 300 | no |
| device_selector | Specifies a pattern to match the 'info name' of devices as reported by `smartctl --scan --json`. | * | no |

</details>

#### Examples

##### Custom devices poll interval

Allows you to override the default devices poll interval (data collection).

<details open><summary>Config</summary>

```yaml
jobs:
  - name: smartctl
    devices_poll_interval: 60  # Collect S.M.A.R.T statistics every 60 seconds

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `smartctl` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m smartctl
  ```


