<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/portcheck/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/portcheck/metadata.yaml"
sidebar_label: "TCP Endpoints"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# TCP Endpoints


<img src="https://netdata.cloud/img/globe.svg" width="150"/>


Plugin: go.d.plugin
Module: portcheck

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors TCP services availability and response time.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per tcp endpoint

These metrics refer to the TCP endpoint.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| host | host |
| port | port |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| portcheck.status | success, failed, timeout | boolean |
| portcheck.state_duration | time | seconds |
| portcheck.latency | time | ms |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ portcheck_service_reachable ](https://github.com/netdata/netdata/blob/master/src/health/health.d/portcheck.conf) | portcheck.status | TCP host ${label:host} port ${label:port} liveness status |
| [ portcheck_connection_timeouts ](https://github.com/netdata/netdata/blob/master/src/health/health.d/portcheck.conf) | portcheck.status | percentage of timed-out TCP connections to host ${label:host} port ${label:port} in the last 5 minutes |
| [ portcheck_connection_fails ](https://github.com/netdata/netdata/blob/master/src/health/health.d/portcheck.conf) | portcheck.status | percentage of failed TCP connections to host ${label:host} port ${label:port} in the last 5 minutes |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/portcheck.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/portcheck.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| host | Remote host address in IPv4, IPv6 format, or DNS name. |  | yes |
| ports | Remote host ports. Must be specified in numeric format. |  | yes |
| timeout | HTTP request timeout. | 2 | no |

</details>

#### Examples

##### Check SSH and telnet

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: server1
    host: 127.0.0.1
    ports:
      - 22
      - 23

```
</details>

##### Check webserver with IPv6 address

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: server2
    host: "[2001:DB8::1]"
    ports:
      - 80
      - 8080

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Multiple instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: server1
    host: 127.0.0.1
    ports:
      - 22
      - 23

  - name: server2
    host: 203.0.113.10
    ports:
      - 22
      - 23

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `portcheck` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m portcheck
  ```


