<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/ping/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/ping/metadata.yaml"
sidebar_label: "Ping"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Ping


<img src="https://netdata.cloud/img/globe.svg" width="150"/>


Plugin: go.d.plugin
Module: ping

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This module measures round-trip time and packet loss by sending ping messages to network hosts.

There are two operational modes:

- privileged (send raw ICMP ping, default). Requires
  CAP_NET_RAW [capability](https://man7.org/linux/man-pages/man7/capabilities.7.html) or root privileges:
  > **Note**: set automatically during Netdata installation.

  ```bash
  sudo setcap CAP_NET_RAW=eip <INSTALL_PREFIX>/usr/libexec/netdata/plugins.d/go.d.plugin
  ```

- unprivileged (send UDP ping, Linux only).
  Requires configuring [ping_group_range](https://www.man7.org/linux/man-pages/man7/icmp.7.html):

  ```bash
  sudo sysctl -w net.ipv4.ping_group_range="0 2147483647"
  ```
  To persist the change add `net.ipv4.ping_group_range="0 2147483647"` to `/etc/sysctl.conf` and
  execute `sudo sysctl -p`.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per host

These metrics refer to the remote host.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| host | remote host |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ping.host_rtt | min, max, avg | milliseconds |
| ping.host_std_dev_rtt | std_dev | milliseconds |
| ping.host_packet_loss | loss | percentage |
| ping.host_packets | received, sent | packets |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ ping_host_reachable ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ping.conf) | ping.host_packet_loss | network host ${lab1el:host} reachability status |
| [ ping_packet_loss ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ping.conf) | ping.host_packet_loss | packet loss percentage to the network host ${label:host} over the last 10 minutes |
| [ ping_host_latency ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ping.conf) | ping.host_rtt | average latency to the network host ${label:host} over the last 10 seconds |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/ping.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/ping.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| hosts | Network hosts. |  | yes |
| network | Allows configuration of DNS resolution. Supported options: ip (select IPv4 or IPv6), ip4 (select IPv4), ip6 (select IPv6). | ip | no |
| privileged | Ping packets type. "no" means send an "unprivileged" UDP ping,  "yes" - raw ICMP ping. | yes | no |
| packets | Number of ping packets to send. | 5 | no |
| interval | Timeout between sending ping packets. | 100ms | no |

</details>

#### Examples

##### IPv4 hosts

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: example
    hosts:
      - 192.0.2.0
      - 192.0.2.1

```
</details>

##### Unprivileged mode

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: example
    privileged: no
    hosts:
      - 192.0.2.0
      - 192.0.2.1

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Multiple instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: example1
    hosts:
      - 192.0.2.0
      - 192.0.2.1

  - name: example2
    packets: 10
    hosts:
      - 192.0.2.3
      - 192.0.2.4

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `ping` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m ping
  ```


