<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/cockroachdb/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/cockroachdb/metadata.yaml"
sidebar_label: "CockroachDB"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# CockroachDB


<img src="https://netdata.cloud/img/cockroachdb.svg" width="150"/>


Plugin: go.d.plugin
Module: cockroachdb

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors CockroachDB servers.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per CockroachDB instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cockroachdb.process_cpu_time_combined_percentage | used | percentage |
| cockroachdb.process_cpu_time_percentage | user, sys | percentage |
| cockroachdb.process_cpu_time | user, sys | ms |
| cockroachdb.process_memory | rss | KiB |
| cockroachdb.process_file_descriptors | open | fd |
| cockroachdb.process_uptime | uptime | seconds |
| cockroachdb.host_disk_bandwidth | read, write | KiB |
| cockroachdb.host_disk_operations | reads, writes | operations |
| cockroachdb.host_disk_iops_in_progress | in_progress | iops |
| cockroachdb.host_network_bandwidth | received, sent | kilobits |
| cockroachdb.host_network_packets | received, sent | packets |
| cockroachdb.live_nodes | live_nodes | nodes |
| cockroachdb.node_liveness_heartbeats | successful, failed | heartbeats |
| cockroachdb.total_storage_capacity | total | KiB |
| cockroachdb.storage_capacity_usability | usable, unusable | KiB |
| cockroachdb.storage_usable_capacity | available, used | KiB |
| cockroachdb.storage_used_capacity_percentage | total, usable | percentage |
| cockroachdb.sql_connections | active | connections |
| cockroachdb.sql_bandwidth | received, sent | KiB |
| cockroachdb.sql_statements_total | started, executed | statements |
| cockroachdb.sql_errors | statement, transaction | errors |
| cockroachdb.sql_started_ddl_statements | ddl | statements |
| cockroachdb.sql_executed_ddl_statements | ddl | statements |
| cockroachdb.sql_started_dml_statements | select, update, delete, insert | statements |
| cockroachdb.sql_executed_dml_statements | select, update, delete, insert | statements |
| cockroachdb.sql_started_tcl_statements | begin, commit, rollback, savepoint, savepoint_cockroach_restart, release_savepoint_cockroach_restart, rollback_to_savepoint_cockroach_restart | statements |
| cockroachdb.sql_executed_tcl_statements | begin, commit, rollback, savepoint, savepoint_cockroach_restart, release_savepoint_cockroach_restart, rollback_to_savepoint_cockroach_restart | statements |
| cockroachdb.sql_active_distributed_queries | active | queries |
| cockroachdb.sql_distributed_flows | active, queued | flows |
| cockroachdb.live_bytes | applications, system | KiB |
| cockroachdb.logical_data | keys, values | KiB |
| cockroachdb.logical_data_count | keys, values | num |
| cockroachdb.kv_transactions | committed, fast-path_committed, aborted | transactions |
| cockroachdb.kv_transaction_restarts | write_too_old, write_too_old_multiple, forwarded_timestamp, possible_reply, async_consensus_failure, read_within_uncertainty_interval, aborted, push_failure, unknown | restarts |
| cockroachdb.ranges | ranges | ranges |
| cockroachdb.ranges_replication_problem | unavailable, under_replicated, over_replicated | ranges |
| cockroachdb.range_events | split, add, remove, merge | events |
| cockroachdb.range_snapshot_events | generated, applied_raft_initiated, applied_learner, applied_preemptive | events |
| cockroachdb.rocksdb_read_amplification | reads | reads/query |
| cockroachdb.rocksdb_table_operations | compactions, flushes | operations |
| cockroachdb.rocksdb_cache_usage | used | KiB |
| cockroachdb.rocksdb_cache_operations | hits, misses | operations |
| cockroachdb.rocksdb_cache_hit_rate | hit_rate | percentage |
| cockroachdb.rocksdb_sstables | sstables | sstables |
| cockroachdb.replicas | replicas | replicas |
| cockroachdb.replicas_quiescence | quiescent, active | replicas |
| cockroachdb.replicas_leaders | leaders, not_leaseholders | replicas |
| cockroachdb.replicas_leaseholders | leaseholders | leaseholders |
| cockroachdb.queue_processing_failures | gc, replica_gc, replication, split, consistency, raft_log, raft_snapshot, time_series_maintenance | failures |
| cockroachdb.rebalancing_queries | avg | queries/s |
| cockroachdb.rebalancing_writes | avg | writes/s |
| cockroachdb.timeseries_samples | written | samples |
| cockroachdb.timeseries_write_errors | write | errors |
| cockroachdb.timeseries_write_bytes | written | KiB |
| cockroachdb.slow_requests | acquiring_latches, acquiring_lease, in_raft | requests |
| cockroachdb.code_heap_memory_usage | go, cgo | KiB |
| cockroachdb.goroutines | goroutines | goroutines |
| cockroachdb.gc_count | gc | invokes |
| cockroachdb.gc_pause | pause | us |
| cockroachdb.cgo_calls | cgo | calls |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ cockroachdb_used_storage_capacity ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cockroachdb.conf) | cockroachdb.storage_used_capacity_percentage | storage capacity utilization |
| [ cockroachdb_used_usable_storage_capacity ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cockroachdb.conf) | cockroachdb.storage_used_capacity_percentage | storage usable space utilization |
| [ cockroachdb_unavailable_ranges ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cockroachdb.conf) | cockroachdb.ranges_replication_problem | number of ranges with fewer live replicas than needed for quorum |
| [ cockroachdb_underreplicated_ranges ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cockroachdb.conf) | cockroachdb.ranges_replication_problem | number of ranges with fewer live replicas than the replication target |
| [ cockroachdb_open_file_descriptors_limit ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cockroachdb.conf) | cockroachdb.process_file_descriptors | open file descriptors utilization (against softlimit) |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/cockroachdb.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/cockroachdb.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. | http://127.0.0.1:8080/_status/vars | yes |
| timeout | HTTP request timeout. | 1 | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080/_status/vars

```
</details>

##### HTTP authentication

Local server with basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080/_status/vars
    username: username
    password: password

```
</details>

##### HTTPS with self-signed certificate

CockroachDB with enabled HTTPS and self-signed certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1:8080/_status/vars
    tls_skip_verify: yes

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080/_status/vars

  - name: remote
    url: http://203.0.113.10:8080/_status/vars

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `cockroachdb` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m cockroachdb
  ```


