<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/oracledb/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/oracledb/metadata.yaml"
sidebar_label: "Oracle DB"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Oracle DB


<img src="https://netdata.cloud/img/oracle.svg" width="150"/>


Plugin: python.d.plugin
Module: oracledb

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors OracleDB database metrics about sessions, tables, memory and more.

It collects the metrics via the supported database client library

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

In order for this collector to work, it needs a read-only user `netdata` in the RDBMS.


### Default Behavior

#### Auto-Detection

When the requirements are met, databases on the local host on port 1521 will be auto-detected

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

These metrics refer to the entire monitored application.

### Per Oracle DB instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| oracledb.session_count | total, active | sessions |
| oracledb.session_limit_usage | usage | % |
| oracledb.logons | logons | events/s |
| oracledb.physical_disk_read_writes | reads, writes | events/s |
| oracledb.sorts_on_disks | sorts | events/s |
| oracledb.full_table_scans | full table scans | events/s |
| oracledb.database_wait_time_ratio | wait time ratio | % |
| oracledb.shared_pool_free_memory | free memory | % |
| oracledb.in_memory_sorts_ratio | in-memory sorts | % |
| oracledb.sql_service_response_time | time | seconds |
| oracledb.user_rollbacks | rollbacks | events/s |
| oracledb.enqueue_timeouts | enqueue timeouts | events/s |
| oracledb.cache_hit_ration | buffer, cursor, library, row | % |
| oracledb.global_cache_blocks | corrupted, lost | events/s |
| oracledb.activity | parse count, execute count, user commits, user rollbacks | events/s |
| oracledb.wait_time | application, configuration, administrative, concurrency, commit, network, user I/O, system I/O, scheduler, other | ms |
| oracledb.tablespace_size | a dimension per active tablespace | KiB |
| oracledb.tablespace_usage | a dimension per active tablespace | KiB |
| oracledb.tablespace_usage_in_percent | a dimension per active tablespace | % |
| oracledb.allocated_size | a dimension per active tablespace | B |
| oracledb.allocated_usage | a dimension per active tablespace | B |
| oracledb.allocated_usage_in_percent | a dimension per active tablespace | % |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install the python-oracledb package

You can follow the official guide below to install the required package:

Source: https://python-oracledb.readthedocs.io/en/latest/user_guide/installation.html


#### Create a read only user for netdata

Follow the official instructions for your oracle RDBMS to create a read-only user for netdata. The operation may follow this approach

Connect to your Oracle database with an administrative user and execute:

```bash
CREATE USER netdata IDENTIFIED BY <PASSWORD>;

GRANT CONNECT TO netdata;
GRANT SELECT_CATALOG_ROLE TO netdata;
```


#### Edit the configuration

Edit the configuration troubleshooting:

1. Provide a valid user for the netdata collector to access the database
2. Specify the network target this database is listening.



### Configuration

#### File

The configuration file name for this integration is `python.d/oracledb.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/oracledb.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| user | The username for the user account. | no | yes |
| password | The password for the user account. | no | yes |
| server | The IP address or hostname (and port) of the Oracle Database Server. | no | yes |
| service | The Oracle Database service name. To view the services available on your server run this query, `select SERVICE_NAME from gv$session where sid in (select sid from V$MYSTAT)`. | no | yes |
| protocol | one of the strings "tcp" or "tcps" indicating whether to use unencrypted network traffic or encrypted network traffic | no | yes |

</details>

#### Examples

##### Basic

A basic example configuration, two jobs described for two databases.

```yaml
local:
    user: 'netdata'
    password: 'secret'
    server: 'localhost:1521'
    service: 'XE'
    protocol: 'tcps'

remote:
    user: 'netdata'
    password: 'secret'
    server: '10.0.0.1:1521'
    service: 'XE'
    protocol: 'tcps'

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `oracledb` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin oracledb debug trace
  ```


