/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

import javafx.beans.NamedArg;

public class Insets {
    public static final Insets EMPTY = new Insets(0.0, 0.0, 0.0, 0.0);
    private double top;
    private double right;
    private double bottom;
    private double left;
    private int hash = 0;

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public Insets(@NamedArg(value="top") double top, @NamedArg(value="right") double right, @NamedArg(value="bottom") double bottom, @NamedArg(value="left") double left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public Insets(@NamedArg(value="topRightBottomLeft") double topRightBottomLeft) {
        this.top = topRightBottomLeft;
        this.right = topRightBottomLeft;
        this.bottom = topRightBottomLeft;
        this.left = topRightBottomLeft;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Insets) {
            Insets other = (Insets)obj;
            return this.top == other.top && this.right == other.right && this.bottom == other.bottom && this.left == other.left;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 17L;
            bits = 37L * bits + Double.doubleToLongBits(this.top);
            bits = 37L * bits + Double.doubleToLongBits(this.right);
            bits = 37L * bits + Double.doubleToLongBits(this.bottom);
            bits = 37L * bits + Double.doubleToLongBits(this.left);
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Insets [top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + "]";
    }
}

