/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.javafx.geom.Rectangle;
import com.sun.prism.ps.Shader;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.PhongLighting;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.ps.PPSTwoSamplerPeer;
import com.sun.scenario.effect.light.PointLight;
import com.sun.scenario.effect.light.SpotLight;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class PPSPhongLighting_DISTANTPeer
extends PPSTwoSamplerPeer {
    private FloatBuffer kvals;

    public PPSPhongLighting_DISTANTPeer(FilterContext fctx, Renderer r, String shaderName) {
        super(fctx, r, shaderName);
    }

    @Override
    protected final PhongLighting getEffect() {
        return (PhongLighting)super.getEffect();
    }

    private float getSurfaceScale() {
        return this.getEffect().getSurfaceScale();
    }

    private float getDiffuseConstant() {
        return this.getEffect().getDiffuseConstant();
    }

    private float getSpecularConstant() {
        return this.getEffect().getSpecularConstant();
    }

    private float getSpecularExponent() {
        return this.getEffect().getSpecularExponent();
    }

    private float[] getNormalizedLightPosition() {
        return this.getEffect().getLight().getNormalizedLightPosition();
    }

    private float[] getLightPosition() {
        PointLight plight = (PointLight)this.getEffect().getLight();
        return new float[]{plight.getX(), plight.getY(), plight.getZ()};
    }

    private float[] getLightColor() {
        return this.getEffect().getLight().getColor().getPremultipliedRGBComponents();
    }

    private float getLightSpecularExponent() {
        return ((SpotLight)this.getEffect().getLight()).getSpecularExponent();
    }

    private float[] getNormalizedLightDirection() {
        return ((SpotLight)this.getEffect().getLight()).getNormalizedLightDirection();
    }

    private FloatBuffer getKvals() {
        Rectangle bumpImgBounds = this.getInputNativeBounds(0);
        float xoff = 1.0f / (float)bumpImgBounds.width;
        float yoff = 1.0f / (float)bumpImgBounds.height;
        float[] kx = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] ky = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer(32);
        }
        this.kvals.clear();
        int kidx = 0;
        float factor = -this.getSurfaceScale() * 0.25f;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i != 0 || j != 0) {
                    this.kvals.put((float)j * xoff);
                    this.kvals.put((float)i * yoff);
                    this.kvals.put(kx[kidx] * factor);
                    this.kvals.put(ky[kidx] * factor);
                }
                ++kidx;
            }
        }
        this.kvals.rewind();
        return this.kvals;
    }

    private int getKvalsArrayLength() {
        return 8;
    }

    @Override
    protected boolean isSamplerLinear(int i) {
        switch (i) {
            default: 
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> samplers = new HashMap<String, Integer>();
        samplers.put("bumpImg", 0);
        samplers.put("origImg", 1);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("normalizedLightPosition", 12);
        params.put("specularExponent", 2);
        params.put("kvals", 4);
        params.put("diffuseConstant", 0);
        params.put("lightColor", 3);
        params.put("specularConstant", 1);
        return this.getRenderer().createShader(this.getShaderName(), samplers, params, false);
    }

    @Override
    protected void updateShader(Shader shader) {
        float[] normalizedLightPosition_tmp = this.getNormalizedLightPosition();
        shader.setConstant("normalizedLightPosition", normalizedLightPosition_tmp[0], normalizedLightPosition_tmp[1], normalizedLightPosition_tmp[2]);
        shader.setConstant("specularExponent", this.getSpecularExponent());
        shader.setConstants("kvals", this.getKvals(), 0, this.getKvalsArrayLength());
        shader.setConstant("diffuseConstant", this.getDiffuseConstant());
        float[] lightColor_tmp = this.getLightColor();
        shader.setConstant("lightColor", lightColor_tmp[0], lightColor_tmp[1], lightColor_tmp[2]);
        shader.setConstant("specularConstant", this.getSpecularConstant());
    }
}

