/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.state.RenderState;

public class Blend
extends CoreEffect<RenderState> {
    private Mode mode;
    private float opacity;

    public Blend(Mode mode, Effect bottomInput, Effect topInput) {
        super(bottomInput, topInput);
        this.setMode(mode);
        this.setOpacity(1.0f);
    }

    public final Effect getBottomInput() {
        return this.getInputs().get(0);
    }

    public void setBottomInput(Effect bottomInput) {
        this.setInput(0, bottomInput);
    }

    public final Effect getTopInput() {
        return this.getInputs().get(1);
    }

    public void setTopInput(Effect topInput) {
        this.setInput(1, topInput);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must be non-null");
        }
        Mode old = this.mode;
        this.mode = mode;
        this.updatePeerKey("Blend_" + mode.name());
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Opacity must be in the range [0,1]");
        }
        float old = this.opacity;
        this.opacity = opacity;
    }

    @Override
    public Point2D transform(Point2D p, Effect defaultInput) {
        return this.getDefaultedInput(1, defaultInput).transform(p, defaultInput);
    }

    @Override
    public Point2D untransform(Point2D p, Effect defaultInput) {
        return this.getDefaultedInput(1, defaultInput).untransform(p, defaultInput);
    }

    @Override
    public RenderState getRenderState(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        return RenderState.RenderSpaceRenderState;
    }

    @Override
    public boolean reducesOpaquePixels() {
        Effect bottomInput = this.getBottomInput();
        Effect topInput = this.getTopInput();
        switch (this.getMode()) {
            case SRC_IN: 
            case SRC_OUT: {
                return true;
            }
            case SRC_ATOP: {
                return bottomInput != null && bottomInput.reducesOpaquePixels();
            }
            case SRC_OVER: 
            case ADD: 
            case MULTIPLY: 
            case SCREEN: 
            case OVERLAY: 
            case DARKEN: 
            case LIGHTEN: 
            case COLOR_DODGE: 
            case COLOR_BURN: 
            case HARD_LIGHT: 
            case SOFT_LIGHT: 
            case DIFFERENCE: 
            case EXCLUSION: 
            case RED: 
            case GREEN: 
            case BLUE: {
                return topInput != null && topInput.reducesOpaquePixels() && bottomInput != null && bottomInput.reducesOpaquePixels();
            }
        }
        return true;
    }

    public static enum Mode {
        SRC_OVER,
        SRC_IN,
        SRC_OUT,
        SRC_ATOP,
        ADD,
        MULTIPLY,
        SCREEN,
        OVERLAY,
        DARKEN,
        LIGHTEN,
        COLOR_DODGE,
        COLOR_BURN,
        HARD_LIGHT,
        SOFT_LIGHT,
        DIFFERENCE,
        EXCLUSION,
        RED,
        GREEN,
        BLUE;

    }
}

