/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.paint;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.impl.paint.MultipleGradientContext;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.LinearGradient;

final class LinearGradientContext
extends MultipleGradientContext {
    private float dgdX;
    private float dgdY;
    private float gc;

    LinearGradientContext(LinearGradient paint, BaseTransform t, float startx, float starty, float endx, float endy, float[] fractions, Color[] colors, int cycleMethod) {
        super(paint, t, fractions, colors, cycleMethod);
        float dx = endx - startx;
        float dy = endy - starty;
        float dSq = dx * dx + dy * dy;
        float constX = dx / dSq;
        float constY = dy / dSq;
        this.dgdX = this.a00 * constX + this.a10 * constY;
        this.dgdY = this.a01 * constX + this.a11 * constY;
        this.gc = (this.a02 - startx) * constX + (this.a12 - starty) * constY;
    }

    @Override
    protected void fillRaster(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        float g = 0.0f;
        int rowLimit = off + w;
        float initConst = this.dgdX * (float)x + this.gc;
        for (int i = 0; i < h; ++i) {
            g = initConst + this.dgdY * (float)(y + i);
            while (off < rowLimit) {
                pixels[off++] = this.indexIntoGradientsArrays(g);
                g += this.dgdX;
            }
            rowLimit = (off += adjust) + w;
        }
    }
}

