/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Glyph;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.packrect.RectanglePacker;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.paint.Color;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.WeakHashMap;

public class GlyphCache {
    private static final int WIDTH = PrismSettings.glyphCacheWidth;
    private static final int HEIGHT = PrismSettings.glyphCacheHeight;
    private static ByteBuffer emptyMask;
    private final BaseContext context;
    private final FontStrike strike;
    private static final int SEGSHIFT = 5;
    private static final int SEGSIZE = 32;
    private static final int SEGMASK = 31;
    HashMap<Integer, GlyphData[]> glyphDataMap = new HashMap();
    private static final int SUBPIXEL_SHIFT = 27;
    private RectanglePacker packer;
    private boolean isLCDCache;
    static WeakHashMap<BaseContext, RectanglePacker> greyPackerMap;
    static WeakHashMap<BaseContext, RectanglePacker> lcdPackerMap;

    public GlyphCache(BaseContext context, FontStrike strike) {
        this.context = context;
        this.strike = strike;
        this.isLCDCache = strike.getAAMode() == 1;
        WeakHashMap<BaseContext, RectanglePacker> packerMap = this.isLCDCache ? lcdPackerMap : greyPackerMap;
        this.packer = packerMap.get(context);
        if (this.packer == null) {
            ResourceFactory factory = context.getResourceFactory();
            Texture tex = factory.createMaskTexture(WIDTH, HEIGHT, Texture.WrapMode.CLAMP_NOT_NEEDED);
            tex.contentsUseful();
            tex.makePermanent();
            if (!this.isLCDCache) {
                factory.setGlyphTexture(tex);
            }
            tex.setLinearFiltering(false);
            this.packer = new RectanglePacker(tex, WIDTH, HEIGHT);
            packerMap.put(context, this.packer);
        }
    }

    public void render(BaseContext ctx, GlyphList gl, float x, float y, int start, int end, Color rangeColor, Color textColor, BaseTransform xform, BaseBounds clip) {
        int dsth;
        int dstw;
        if (this.isLCDCache) {
            dstw = ctx.getLCDBuffer().getPhysicalWidth();
            dsth = ctx.getLCDBuffer().getPhysicalHeight();
        } else {
            dstw = 1;
            dsth = 1;
        }
        Texture tex = this.getBackingStore();
        VertexBuffer vb = ctx.getVertexBuffer();
        int len = gl.getGlyphCount();
        Color currentColor = null;
        Point2D pt = new Point2D();
        for (int gi = 0; gi < len; ++gi) {
            int gc = gl.getGlyphCode(gi);
            if ((gc & 0xFFFFFF) == 65535) continue;
            pt.setLocation(x + gl.getPosX(gi), y + gl.getPosY(gi));
            int subPixel = this.strike.getQuantizedPosition(pt);
            GlyphData data = this.getCachedGlyph(gc, subPixel);
            if (data == null) continue;
            if (clip != null) {
                if (x + gl.getPosX(gi) > clip.getMaxX()) break;
                if (x + gl.getPosX(gi + 1) < clip.getMinX()) continue;
            }
            if (rangeColor != null && textColor != null) {
                int offset = gl.getCharOffset(gi);
                if (start <= offset && offset < end) {
                    if (rangeColor != currentColor) {
                        vb.setPerVertexColor(rangeColor, 1.0f);
                        currentColor = rangeColor;
                    }
                } else if (textColor != currentColor) {
                    vb.setPerVertexColor(textColor, 1.0f);
                    currentColor = textColor;
                }
            }
            xform.transform(pt, pt);
            this.addDataToQuad(data, vb, tex, pt.x, pt.y, dstw, dsth);
        }
    }

    private void addDataToQuad(GlyphData data, VertexBuffer vb, Texture tex, float x, float y, float dstw, float dsth) {
        y = Math.round(y);
        Rectangle rect = data.getRect();
        if (rect == null) {
            return;
        }
        int border = data.getBlankBoundary();
        float gw = rect.width - border * 2;
        float gh = rect.height - border * 2;
        float dx1 = (float)data.getOriginX() + x;
        float dy1 = (float)data.getOriginY() + y;
        float dy2 = dy1 + gh;
        float tw = tex.getPhysicalWidth();
        float th = tex.getPhysicalHeight();
        float tx1 = (float)(rect.x + border) / tw;
        float ty1 = (float)(rect.y + border) / th;
        float tx2 = tx1 + gw / tw;
        float ty2 = ty1 + gh / th;
        if (this.isLCDCache) {
            dx1 = (float)Math.round(dx1 * 3.0f) / 3.0f;
            float dx2 = dx1 + gw / 3.0f;
            float t2x1 = dx1 / dstw;
            float t2x2 = dx2 / dstw;
            float t2y1 = dy1 / dsth;
            float t2y2 = dy2 / dsth;
            vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2, t2x1, t2y1, t2x2, t2y2);
        } else {
            dx1 = Math.round(dx1);
            float dx2 = dx1 + gw;
            if (this.context.isSuperShaderEnabled()) {
                vb.addSuperQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2, true);
            } else {
                vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
            }
        }
    }

    public Texture getBackingStore() {
        return this.packer.getBackingStore();
    }

    public void clear() {
        this.glyphDataMap.clear();
    }

    private void clearAll() {
        this.context.flushVertexBuffer();
        this.context.clearGlyphCaches();
        this.packer.clear();
    }

    private GlyphData getCachedGlyph(int glyphCode, int subPixel) {
        int segIndex = glyphCode >>> 5;
        int subIndex = glyphCode & 0x1F;
        GlyphData[] segment = this.glyphDataMap.get(segIndex |= subPixel << 27);
        if (segment != null) {
            if (segment[subIndex] != null) {
                return segment[subIndex];
            }
        } else {
            segment = new GlyphData[32];
            this.glyphDataMap.put(segIndex, segment);
        }
        GlyphData data = null;
        Glyph glyph = this.strike.getGlyph(glyphCode);
        if (glyph != null) {
            byte[] glyphImage = glyph.getPixelData(subPixel);
            if (glyphImage == null || glyphImage.length == 0) {
                data = new GlyphData(0, 0, 0, glyph.getPixelXAdvance(), glyph.getPixelYAdvance(), null);
            } else {
                MaskData maskData = MaskData.create(glyphImage, glyph.getOriginX(), glyph.getOriginY(), glyph.getWidth(), glyph.getHeight());
                int border = 1;
                int rectW = maskData.getWidth() + 2 * border;
                int rectH = maskData.getHeight() + 2 * border;
                int originX = maskData.getOriginX();
                int originY = maskData.getOriginY();
                Rectangle rect = new Rectangle(0, 0, rectW, rectH);
                data = new GlyphData(originX, originY, border, glyph.getPixelXAdvance(), glyph.getPixelYAdvance(), rect);
                if (!this.packer.add(rect)) {
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.incrementCounter("Font Glyph Cache Cleared");
                    }
                    this.clearAll();
                    if (!this.packer.add(rect)) {
                        if (PrismSettings.verbose) {
                            System.out.println(rect + " won't fit in GlyphCache");
                        }
                        return null;
                    }
                }
                boolean skipFlush = true;
                Texture backingStore = this.getBackingStore();
                int emw = rect.width;
                int emh = rect.height;
                int bpp = backingStore.getPixelFormat().getBytesPerPixelUnit();
                int stride = emw * bpp;
                int size = stride * emh;
                if (emptyMask == null || size > emptyMask.capacity()) {
                    emptyMask = BufferUtil.newByteBuffer(size);
                }
                try {
                    backingStore.update(emptyMask, backingStore.getPixelFormat(), rect.x, rect.y, 0, 0, emw, emh, stride, skipFlush);
                }
                catch (Exception e) {
                    if (PrismSettings.verbose) {
                        e.printStackTrace();
                    }
                    return null;
                }
                maskData.uploadToTexture(backingStore, border + rect.x, border + rect.y, skipFlush);
            }
            segment[subIndex] = data;
        }
        return data;
    }

    static {
        greyPackerMap = new WeakHashMap();
        lcdPackerMap = new WeakHashMap();
    }

    static class GlyphData {
        private final int originX;
        private final int originY;
        private final int blankBoundary;
        private final float xAdvance;
        private final float yAdvance;
        private final Rectangle rect;

        GlyphData(int originX, int originY, int blankBoundary, float xAdvance, float yAdvance, Rectangle rect) {
            this.originX = originX;
            this.originY = originY;
            this.blankBoundary = blankBoundary;
            this.xAdvance = xAdvance;
            this.yAdvance = yAdvance;
            this.rect = rect;
        }

        int getOriginX() {
            return this.originX;
        }

        int getOriginY() {
            return this.originY;
        }

        int getBlankBoundary() {
            return this.blankBoundary;
        }

        float getXAdvance() {
            return this.xAdvance;
        }

        float getYAdvance() {
            return this.yAdvance;
        }

        Rectangle getRect() {
            return this.rect;
        }
    }
}

