/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GraphicsPipeline {
    private FontFactory fontFactory;
    private final Set<Runnable> disposeHooks = new HashSet<Runnable>();
    protected Map deviceDetails = null;
    private static GraphicsPipeline installedPipeline;

    public abstract boolean init();

    public void dispose() {
        this.notifyDisposeHooks();
        installedPipeline = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeHook(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Set<Runnable> set = this.disposeHooks;
        synchronized (set) {
            this.disposeHooks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDisposeHooks() {
        ArrayList<Runnable> hooks;
        Set<Runnable> set = this.disposeHooks;
        synchronized (set) {
            hooks = new ArrayList<Runnable>(this.disposeHooks);
            this.disposeHooks.clear();
        }
        for (Runnable hook : hooks) {
            hook.run();
        }
    }

    public abstract int getAdapterOrdinal(Screen var1);

    public abstract ResourceFactory getResourceFactory(Screen var1);

    public abstract ResourceFactory getDefaultResourceFactory(List<Screen> var1);

    public abstract boolean is3DSupported();

    public boolean isMSAASupported() {
        return false;
    }

    public abstract boolean isVsyncSupported();

    public abstract boolean supportsShaderType(ShaderType var1);

    public abstract boolean supportsShaderModel(ShaderModel var1);

    public boolean supportsShader(ShaderType type, ShaderModel model) {
        return this.supportsShaderType(type) && this.supportsShaderModel(model);
    }

    public static ResourceFactory getDefaultResourceFactory() {
        List<Screen> screens = Screen.getScreens();
        return GraphicsPipeline.getPipeline().getDefaultResourceFactory(screens);
    }

    public FontFactory getFontFactory() {
        if (this.fontFactory == null) {
            this.fontFactory = PrismFontFactory.getFontFactory();
        }
        return this.fontFactory;
    }

    public Map getDeviceDetails() {
        return this.deviceDetails;
    }

    protected void setDeviceDetails(Map details) {
        this.deviceDetails = details;
    }

    public static GraphicsPipeline createPipeline() {
        if (PrismSettings.tryOrder.isEmpty()) {
            if (PrismSettings.verbose) {
                System.out.println("No Prism pipelines specified");
            }
            return null;
        }
        if (installedPipeline != null) {
            throw new IllegalStateException("pipeline already created:" + installedPipeline);
        }
        for (String prefix : PrismSettings.tryOrder) {
            if ("j2d".equals(prefix)) {
                System.err.println("WARNING: The prism-j2d pipeline should not be used as the software");
                System.err.println("fallback pipeline. It is no longer tested nor intended to be used for");
                System.err.println("on-screen rendering. Please use the prism-sw pipeline instead by setting");
                System.err.println("the \"prism.order\" system property to \"sw\" rather than \"j2d\".");
            }
            if (PrismSettings.verbose && ("j2d".equals(prefix) || "sw".equals(prefix))) {
                System.err.println("*** Fallback to Prism SW pipeline");
            }
            String className = "com.sun.prism." + prefix + "." + prefix.toUpperCase() + "Pipeline";
            try {
                Method m;
                GraphicsPipeline newPipeline;
                if (PrismSettings.verbose) {
                    System.out.println("Prism pipeline name = " + className);
                }
                Class<?> klass = Class.forName(className);
                if (PrismSettings.verbose) {
                    System.out.println("(X) Got class = " + klass);
                }
                if ((newPipeline = (GraphicsPipeline)(m = klass.getMethod("getInstance", null)).invoke(null, (Object[])null)) != null && newPipeline.init()) {
                    if (PrismSettings.verbose) {
                        System.out.println("Initialized prism pipeline: " + klass.getName());
                    }
                    installedPipeline = newPipeline;
                    return installedPipeline;
                }
                if (newPipeline != null) {
                    newPipeline.dispose();
                    newPipeline = null;
                }
                if (!PrismSettings.verbose) continue;
                System.err.println("GraphicsPipeline.createPipeline: error initializing pipeline " + className);
            }
            catch (Throwable t) {
                if (!PrismSettings.verbose) continue;
                System.err.println("GraphicsPipeline.createPipeline failed for " + className);
                t.printStackTrace();
            }
        }
        StringBuffer sBuf = new StringBuffer("Graphics Device initialization failed for :  ");
        Iterator<String> orderIterator = PrismSettings.tryOrder.iterator();
        if (orderIterator.hasNext()) {
            sBuf.append(orderIterator.next());
            while (orderIterator.hasNext()) {
                sBuf.append(", ");
                sBuf.append(orderIterator.next());
            }
        }
        System.err.println(sBuf);
        return null;
    }

    public static GraphicsPipeline getPipeline() {
        return installedPipeline;
    }

    public boolean isEffectSupported() {
        return true;
    }

    public boolean isUploading() {
        return PrismSettings.forceUploadingPainter;
    }

    public static enum ShaderModel {
        SM3;

    }

    public static enum ShaderType {
        HLSL,
        GLSL;

    }
}

